package dynamodb

import (
	"context"

	"code.justin.tv/vodsvc/vhs/src/types"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/aws/aws-sdk-go/service/dynamodb/dynamodbattribute"
)

func (d *ddb) DeleteVideo(ctx context.Context, id string) (types.Video, error) {
	input := &dynamodb.DeleteItemInput{
		TableName:    aws.String(d.table),
		Key:          map[string]*dynamodb.AttributeValue{"Id": {S: aws.String(id)}},
		ReturnValues: aws.String("ALL_OLD"),
	}

	video := types.Video{}
	out, err := d.client.DeleteItemWithContext(ctx, input)
	if err != nil {
		return video, err
	}

	if err := dynamodbattribute.UnmarshalMap(out.Attributes, &video); err != nil {
		return video, err
	}

	return video, nil
}
