package dynamodb

import (
	"context"

	"code.justin.tv/vodsvc/vhs/src/types"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/aws/aws-sdk-go/service/dynamodb/dynamodbattribute"
)

func (d *ddb) ListVideos(ctx context.Context, startKey string) ([]types.Video, string, error) {

	input := &dynamodb.ScanInput{
		TableName: aws.String(d.table),
		Limit:     aws.Int64(ScanLimit),
	}

	if len(startKey) > 0 {
		input.ExclusiveStartKey = map[string]*dynamodb.AttributeValue{
			"Id": {S: aws.String(startKey)},
		}
	}

	videos := []types.Video{}
	out, err := d.client.ScanWithContext(ctx, input)
	if err != nil {
		return videos, "", err
	}

	if err := dynamodbattribute.UnmarshalListOfMaps(out.Items, &videos); err != nil {
		return videos, "", err
	}

	for i, _ := range videos {
		if err := transformDeleteTime(&videos[i]); err != nil {
			return videos, "", err
		}
	}

	lastEvaluatedKey, ok := out.LastEvaluatedKey["Id"]
	if !ok {
		return videos, "", nil
	}

	return videos, *lastEvaluatedKey.S, nil
}
