package dynamodb

import (
	"context"
	"strconv"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/dynamodb"
)

func (d *ddb) SetSize(ctx context.Context, id string, size int64) error {
	input := &dynamodb.UpdateItemInput{
		TableName:        aws.String(d.table),
		Key:              map[string]*dynamodb.AttributeValue{"Id": {S: aws.String(id)}},
		UpdateExpression: aws.String("SET #size = :Size, LastUpdated = :Time"),
		ExpressionAttributeNames: map[string]*string{
			"#size": aws.String("Size"),
		},
		ExpressionAttributeValues: map[string]*dynamodb.AttributeValue{
			":Size": {N: aws.String(strconv.FormatInt(size, 10))},
			":Time": {S: aws.String(now3339())},
		},
	}

	_, err := d.client.UpdateItemWithContext(ctx, input)
	return err
}
