package dynamodb

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/aws/aws-sdk-go/service/dynamodb/expression"
)

const (
	DateFormat = "2006-01-02"
	TimeFormat = "15:04:05.99999999Z"
)

func (d *ddb) SetVideoDeleteTime(ctx context.Context, id string, t time.Time) error {
	t = t.UTC()
	update := expression.Set(expression.Name("DeleteDate"), expression.Value(t.Format(DateFormat)))
	update.Set(expression.Name("DeleteTime"), expression.Value(t.Format(TimeFormat)))
	expr, err := expression.NewBuilder().WithUpdate(update).Build()
	if err != nil {
		return err
	}

	input := &dynamodb.UpdateItemInput{
		TableName:                 aws.String(d.table),
		Key:                       map[string]*dynamodb.AttributeValue{"Id": {S: aws.String(id)}},
		UpdateExpression:          expr.Update(),
		ExpressionAttributeNames:  expr.Names(),
		ExpressionAttributeValues: expr.Values(),
	}

	_, err = d.client.UpdateItemWithContext(ctx, input)
	return err
}
