package awsutils

import (
	"log"
	"strings"
	"testing"

	"github.com/stretchr/testify/require"
)

func TestEmptySnsArn(t *testing.T) {
	err := ValidateSnsArn("")
	require.NotNil(t, err)
	require.True(t, strings.Contains(err.Error(), "SNS ARN is empty"))
}

func TestInvalidSnsPrefix(t *testing.T) {
	err := ValidateSnsArn("invalid:prefix:")
	require.NotNil(t, err)
	require.True(t, strings.Contains(err.Error(), "invalid ARN prefix"))
}

func TestInvalidSnsFormat(t *testing.T) {
	err := ValidateSnsArn("arn:aws:sns::")
	require.NotNil(t, err)
	log.Println(err)
	require.True(t, strings.Contains(err.Error(), "invalid format"))
}

func TestInvalidRegion(t *testing.T) {
	err := ValidateSnsArn("arn:aws:sns:us-east-2::test")
	require.NotNil(t, err)
	require.True(t, strings.Contains(err.Error(), "has invalid region"))
}

func TestValidateSnsArn(t *testing.T) {
	err := ValidateSnsArn("arn:aws:sns:us-west-2:123456:test")
	require.Nil(t, err)
}

func TestInvalidTopicName(t *testing.T) {
	err := ValidateSnsArn("arn:aws:sns:us-west-2:123456:")
	require.NotNil(t, err)
	require.True(t, strings.Contains(err.Error(), "invalid topicname"))
}
