package constants

const (
	// STATUS_LIVE represents if a stream is live
	STATUS_LIVE = "live"
	// STATUS_PREPARING represents if a stream is still being prepared
	STATUS_PREPARING = "preparing"
	// HEALTH_STATUS_STABLE represents Health status of a stream which is stable
	HEALTH_STATUS_STABLE = "stable"
	// TRANSCODE_ACTIVE represents stream  being transcoded
	TRANSCODE_ACTIVE = "active"
	// TRANSCODE_PENDING represents the stream transcoding has not yet begun
	TRANSCODE_PENDING = "pending"
	// STREAM_TYPE_ALL request type for ListStreams which requests all the available streams
	STREAM_TYPE_ALL = "all"
	// STREAM_TYPE_LIVE request type for ListStreams which requests all the live streams
	STREAM_TYPE_LIVE = "live"
	// STREAM_TYPE_PREPARING request type for ListStreams which requests all the streams still in prepare state
	STREAM_TYPE_PREPARING = "preparing"

	//US_WEST2_REGION region is the us-west-2 region we accept
	US_WEST2_REGION = "us-west-2"
	//S3_ARN_PREFIX the prefix used for S3 ARNS
	S3_ARN_PREFIX = "arn:aws:s3:"
	//HTTP_PREFIX the http prefix used for s3 buckets
	HTTP_PREFIX = "http://"
	//HTTPS_PREFIX the https prefix used for s3 buckets
	HTTPS_PREFIX = "https://"
	//ARN_SEPARATOR is the way different arn components are separated
	ARN_SEPARATOR = ":"
	//SNS_ARN_PREFIX is the prefix for all SNS ARN's
	SNS_ARN_PREFIX = "arn:aws:sns"
	//METRICS_HTTP_ERROR is used to log http error codes
	METRICS_HTTP_ERROR = "viewcount_api_http_error"
)
