package lambda

import (
	"os"
	"strings"
)

func inLambda() bool {
	return len(os.Getenv("LAMBDA_TASK_ROOT")) > 0
}

func parseArgs() map[string]string {
	params := map[string]string{}

	if len(os.Args) > 1 {
		for _, a := range os.Args[1:] {
			kv := strings.Split(a, "=")
			if len(kv) == 2 {
				k := kv[0]
				v := kv[1]
				params[k] = v
			}
		}
	}

	return params
}
