package transcode

import (
	"os"

	"code.justin.tv/vodsvc/aws/awsconfig"
	sts "code.justin.tv/vodsvc/sts/src/transcoder"
	"code.justin.tv/vodsvc/vhs/src/types"
	"code.justin.tv/vodsvc/vhs/src/vhslog"
	"github.com/aws/aws-sdk-go/service/batch"
	"go.uber.org/zap"
)

// Transcoder interface for submitting a transcoding request
type Transcoder interface {
	StartTranscode(uploadId, uploadTable string) error
	ParseManifest(video types.Video, manifest sts.Video) types.Video
}

type transcoder struct {
	batch         *batch.Batch
	logger        *zap.SugaredLogger
	jobQueue      string
	jobDefinition string
}

func NewFromEnv() Transcoder {
	jobDefinition := os.Getenv("TRANSCODE_JOB_DEFINITION")
	jobQueue := os.Getenv("TRANSCODE_JOB_QUEUE")
	return New(jobQueue, jobDefinition, vhslog.Logger)
}

// New instantiate a transcoder client object
func New(jobQueue, jobDefinition string, logger *zap.SugaredLogger) Transcoder {
	return &transcoder{
		batch:         batch.New(awsconfig.Session),
		logger:        logger,
		jobQueue:      jobQueue,
		jobDefinition: jobDefinition,
	}
}
