package transcode

import (
	"strconv"

	sts "code.justin.tv/vodsvc/sts/src/transcoder"
	"code.justin.tv/vodsvc/vhs/src/types"
)

func (t *transcoder) ParseManifest(video types.Video, manifest sts.Video) types.Video {
	video.Duration = int(manifest.Duration)
	video.Renditions = make([]types.Rendition, len(manifest.Renditions))

	for i, r := range manifest.Renditions {
		video.Renditions[i] = toRendition(r)
	}

	firstThumb := toThumbnail(manifest.Thumbnails[0])
	video.Thumbnails = []types.Thumbnail{firstThumb}

	return video
}

func toThumbnail(t sts.Thumbnail) types.Thumbnail {
	return types.Thumbnail{
		Path:   t.Path,
		Offset: t.Offset,
	}
}

func toRendition(r sts.Rendition) types.Rendition {
	return types.Rendition{
		AudioCodec: r.AudioCodec,
		VideoCodec: r.VideoCodec,
		Bitrate:    r.Bitrate,
		Height:     r.Height,
		Width:      r.Width,
		FPS:        strconv.FormatFloat(r.MaxFPS, 'f', 2, 64),
		Label:      r.Label,
		Manifest:   r.Manifest,
	}
}
