package vhsclient

import (
	"fmt"
	"net/http"

	"code.justin.tv/vodsvc/vhs/src/types"
)

func (c *Client) GetVideo(id string) (types.Video, error) {
	path := "/videos/" + id
	video := types.Video{}

	err := c.requestJSON(http.MethodGet, path, &video)
	if err != nil {
		return video, fmt.Errorf("Error getting video: id=" + id + ", err=" + err.Error())
	}

	c.logger.Log("GetVideo; id=", video.Id)
	return video, nil
}

func (c *Client) ListVideos(paginationToken ...string) (types.ListVideosResponse, error) {
	path := "/videos"
	if len(paginationToken) > 0 {
		path = path + "?paginationToken=" + paginationToken[0]
	}
	videos := types.ListVideosResponse{}

	err := c.requestJSON(http.MethodGet, path, &videos)
	if err != nil {
		return videos, fmt.Errorf("Error listing videos: " + err.Error())
	}

	c.logger.Log("ListVideos; count=", videos.Count)
	return videos, nil
}

func (c *Client) DeleteVideo(id string) error {
	path := "/videos/" + id

	_, err := c.request(http.MethodDelete, path)
	if err != nil {
		return fmt.Errorf("Error deleting video: id=" + id + ", err=" + err.Error())
	}

	c.logger.Log("DeleteVideo; id=", id)
	return nil
}
