package jwt

import (
	"reflect"
	"testing"
)

func TestLoadPublicKey(t *testing.T) {
	t.Log("loading keys")
	pkey, err := ReadRSAPrivateKey("_key/id_rsa.pem")
	if err != nil {
		t.Fatal(err)
	}

	pubkey, err := ReadRSAPublicKey("_key/id_rsa.pub.pem")
	if err != nil {
		t.Fatal(err)
	}

	t.Logf("%+v ?= %+v", pkey.PublicKey, *pubkey)
	if !reflect.DeepEqual(pkey.PublicKey, *pubkey) {
		t.Fatal("inequal")
	}
}
