package jwt

import (
	"bytes"
	"reflect"
	"testing"
)

//jwt.io
func TestDecodeEncode(t *testing.T) {
	var header = interface{}(struct {
		Alg string `json:"alg"`
		Typ string `json:"typ"`
	}{"HS256", "JWT"})

	var body = interface{}(struct {
		Sub   string `json:"sub"`
		Name  string `json:"name"`
		Admin bool   `json:"admin"`
	}{"1234567890", "John Doe", true})

	var b bytes.Buffer
	if _, err := Write(header, body, HS256([]byte("secret")), &b); err != nil {
		t.Fatal(err)
	}

	var newBody = struct {
		Sub   string `json:"sub"`
		Name  string `json:"name"`
		Admin bool   `json:"admin"`
	}{}

	if err := DecodeAndValidate(&header, &newBody, HS256([]byte("secret")), b.Bytes()); err != nil {
		t.Fatal(err)
	}

	if !reflect.DeepEqual(body, newBody) {
		t.Fatalf("Decode failed %+v != %+v", body, newBody)
	}

}
