package main

import (
	"fmt"
	"os"

	"github.com/urfave/cli"
)

var (
	App       = cli.NewApp()
	IsVerbose = false
)

func LogMsg(msg string) {
	if !IsVerbose {
		return
	}
	fmt.Println(msg)
}

func init() {
	cli.VersionFlag = cli.BoolFlag{
		Name:  "version, V",
		Usage: "print the version",
	}
	App.Name = "twerk"
	App.Version = "0.9.0"
	App.Usage = "Command-line-utility for performaing various Twitch QE tasks."
}

func main() {
	App.Run(os.Args)
}
