package main

import (
	"testing"
)

func TestGetChannel(t *testing.T) {
	testCases := []struct {
		channel  string
		rtmpUrl  string
		expected string
		isErr    bool
	}{
		// Old behavior non LVS channels
		{"testChannel1", "test", "testChannel1", false},
		{"testChannel2", "", "testChannel2", false},
		{"testChannel3", "rtmp://VALID_IP/app/live_user_testChannel3", "testChannel3", false},

		// Old behavior LVS channles but not dark launch
		{"lvs.testChannel4", "rtmp://VALID_IP/app/live_user_testChannel3", "lvs.testChannel4", false},
		{"lvs.testChannel5", "IGNORED", "lvs.testChannel5", false},
		{"lvs.testChannel6", "", "lvs.testChannel6", false},

		// New behaviour if the channel is an LVS channel read the RTMP URL
		{"lvs.twitch-lowlatency-darklaunch.1234567", "rtmp://invalid uri", "", true},
		{"lvs.twitch-lowlatency-darklaunch.1234567", "rtmp://VALID_IP/app/INVALID_API", "", true},
		{"lvs.twitch-lowlatency-darklaunch.1234567", "INVALID RTMP URL", "", true},
		{"lvs.twitch-lowlatency-darklaunch.VALID_CHANNEL", "rtmp://VALID_IP/app/live_user_VALID_CHANNEL", "VALID_CHANNEL", false},
	}

	for _, in := range testCases {
		actual, err := getChannelName(in.channel, in.rtmpUrl)
		isErr := err != nil
		if actual != in.expected || isErr != in.isErr {
			t.Fatalf("getChannelName('%s', '%s') = '%s', '%v', expected = '%s', expected to error = '%t'",
				in.channel, in.rtmpUrl, actual, err, in.expected, in.isErr)
		}
	}
}
