/*
Package main contants should include all contant names
*/
package main

import "time"

const (

	// Default GoTranscoder Config
	constGotranscoderConfig = "config/default_config.json"

	// plugin timeouts
	constPluginProcessTimeout = 500 * time.Millisecond

	// Beta toggle switches
	constConsistentHashPrecision = 1000

	// Usher DB Options
	constDbOptionTranscoderBetaRatio = "transcoder_beta_ratio"

	// Statsd routes
	constStatsCleanExit           = "exit.clean"
	constStatsUnexpectedExit      = "exit.unexpected"
	constStatsSignalBrakeExit     = "exit.signal"
	constStatsExecutionTime       = "execution_time"
	constStatsGotStartTime        = "process.start"
	constTranscodeReady           = "ready.ok"
	constTranscodeReadyFail       = "ready.fail"
	constEsUnsampledLog           = "tracking.elastiscsearch.unsampled"
	constEsSampledLog             = "tracking.elastiscsearch.sampled"
	constUsherTranscodeUpdate     = "usherapi.hlstranscode"
	constUsherChanPropsUpdate     = "usherapi.channelproperties"
	constUsherTranscodeUpdErr     = "usherapi.hlstranscode.errors"
	constAdBreakRequest           = "ads.request"
	constTimeToTranscode          = "time_from.stream_to_transcode"
	constTimeToInitialized        = "time_from.init_to_transcode"
	constTimeToActive             = "time_from.init_to_active"
	constTimeInitToProbe          = "time_from.init_to_probe"
	probeFailCount                = "probe.fail"
	constLowBitrateHighResolution = "probe.channels_lowbitrate_highresolution"
	constVodPusherUnheatlhy       = "vod_pusher.unhealthy"
	constLegacyAdInsertionFailure = "legacy_ad.insertion.fail"
	constLegacyAdDecodeFailure    = "legacy_ad.decode.fail"
	constStatsSNSNotification     = "notification.fail.%s"
	constSpadeEventSuccess        = "spade.success"
	constSpadeEventFailure        = "spade.failure"
	constTenfootPlaylistFailure   = "tenfoot.post_playlist.failure"
	constTenfootSegmentFailure    = "tenfoot.post_segment.failure"
	constStatsTTStable            = "tt_version_selected.stable"
	constStatsTTBeta              = "tt_version_selected.beta"
	constStatsTTPatched           = "tt_version_selected.patched"

	// Fixed trans* qualities
	constTranscodeAudioOnly = "audio_only"
	constTranscodeSource    = "chunked"
	constTranscodeThumb     = "thumb"

	// transcode constants
	constTranscodePathAudio   = "%s/audio_only"
	constTranscodePathThumb   = "%s/thumb"
	constTranscodePathSprites = "%s/sprites"
	constTranscodePathSource  = "%s/chunked"

	//playlist constants
	constPlaylistPrefix  = "index"
	constVODPlaylistName = "index-dvr.m3u8"

	// transcode quality settings
	constSettingsTranscodeProfiles  = "./config/transcode_profiles.json"
	constSettingsTranscodeQualities = "./config/transcode_qualities.json"

	// Playlists
	constLivePlaylist    = "live"
	constHistoryPlaylist = "history"
	constWeaverPlaylist  = "weaver"

	// Playlist flags
	// TODO: make this configurable via toggles
	constTranscodeLivePlaylistWindowSize    = 6
	constTranscodeHistoryPlaylistWindowSize = 200
	constTranscodeWeaverPlaylistWindowSize  = 200
	constTranscodeUsherUpdateMillis         = 30000
	constUsherUpdateStreamMillis            = 30000
	constTranscodeOptimizeTs                = false
	constTranscodeHlsValidation             = true
	constTranscodeQualityMetrics            = false
	constTranscodeEncoderMetrics            = false
	constTwitchTranscoderGeneratePlaylist   = false

	// override Beta transcoder from environmental variable
	constBetaTranscoderOverrideEnvVar = "FORCE_BETA_TRANSCODER"
	constIntelSDKEnvVar               = "INTEL_MEDIA_SDK_VERSION"
	constPatchedSDKVersion            = "16.8"

	// tolerance value for float comparison
	constFloatTolerance = 0.000001

	//Rivia specific constants
	riviaVersion                   = 2
	const720p60MinBitrateThreshold = 4500000
	constTransportCostMultiplier   = 1.05

	//EncoderTypes
	quickSyncEncoderType = "quicksync"

	//Video Width calculcator mask 0xFFFFFC
	constVideoWithCalculatorMask = 0xFFFFFC

	const720pVideoHeight  = 720
	const1080pVideoHeight = 1080

	// Sprite configs
	// The minimum allowed interval between thumbnails when generating spritesheets in ms
	spriteMinIntervalMilliseconds = 2000
	spriteMinThumbnailWidth       = 32
	spriteMinThumbnailHeight      = 32

	// Segment duration defaults
	constMaxSegmentDuration     = 10100
	constMinSegmentDuration     = 900
	constAverageSegmentDuration = 2000

	//Default audio and video probe values
	defaultVideoheight    = 1080
	defaultVideowidth     = 1920
	defaultVideoFps       = 60
	defaultVideoCodec     = "avc1.4D4020"
	defaultVideoBitRate   = 6000000
	defaultAudioBitRate   = 160000
	defaultAudioCodec     = "mp4a.40.2"
	defaultMaxIdrInterval = 2000
	legacyAdBreakMetadata = `INJECT_METADATA: commercial:{"length": "%d", "cmd": "commercial"}`

	lvsS3VodUrl       = "s3_vod_url"
	lvsSNSEndpoint    = "sns_endpoint"
	lvsVodManifestUrl = "vod_manifest_url"

	// S3 VOD URL Format
	lvsS3VodUrlFormat = "https://%s.s3.amazonaws.com/%s"

	// LOW LATENCY DARKLAUNCH CUSTOMER_ID
	lowLatencyDarkLaunchPrefix = "lvs.twitch-lowlatency-darklaunch."

	//
	manifestPath = "manifest/vod.m3u8"

	// Segment File Extension
	fileFormatFmp4 = "fmp4"
	fileFormatTS   = "ts"
)
