job {
	name "video-gotranscoder"
	using 'TEMPLATE-autobuild'

	scm {
		git {
			remote {
				github 'video/gotranscoder', 'ssh', 'git-aws.internal.justin.tv'
					credentials 'git-aws-read-key'
			}
			clean true
		}
	}
	steps {
		shell 'rm -rf .manta_precise/'
		shell 'manta -v -proxy'
		saveDeployArtifact 'video/gotranscoder', '.manta'
	}
	wrappers {
		colorizeOutput()
			credentialsBinding {
				file('COURIERD_PRIVATE_KEY', 'courierd')
					file('AWS_CONFIG_FILE', 'aws_config')
					string 'AWS_ACCESS_KEY_ID', 'core-deploy-artifacts-access-key'
					string 'AWS_SECRET_ACCESS_KEY', 'core-deploy-artifacts-secret-key'
			}
	}
	publishers {
		flexiblePublish {
			conditionalAction {
				condition { alwaysRun() }
				steps {
					reportCodeCoverage('video/gotranscoder', '.manta', '*.out')
				}
			}
		}
		archiveArtifacts('.manta/test_report.xml', 'codecov_coverage.json')
		archiveJunit('.manta/test_report.xml')
	}
}

job {
	name "video-gotranscoder"
	using 'TEMPLATE-autobuild'
	wrappers {
		colorizeOutput()
		credentialsBinding {
	                file('COURIERD_PRIVATE_KEY', 'courierd')
	                file('AWS_CONFIG_FILE', 'aws_config')
			string 'AWS_ACCESS_KEY_ID', 'deploy-artifacts-access-key'
			string 'AWS_SECRET_ACCESS_KEY', 'deploy-artifacts-secret-key'
		}
		environmentVariables {
			env('GIT_BRANCH', '${GIT_BRANCH}')
			env('GIT_COMMIT', '${GIT_COMMIT}')
			env('GIT_URL', '${GIT_URL}')
		}
	}
	scm {
		git {
			remote {
				github 'video/gotranscoder', 'ssh', 'git-aws.internal.justin.tv'
				credentials 'git-aws-read-key'
			}
			clean true
		}
	}
	steps {
          shell '''#!/bin/bash
set -euo pipefail
go get -u github.com/jstemmer/go-junit-report

export AWS_ACCESS_KEY_ID=$AWS_ACCESS_KEY_ID
export AWS_SECRET_ACCESS_KEY=$AWS_SECRET_ACCESS_KEY
bingo lint --container
bingo test -v --coverage=cover.out --container | tee test_report.txt
bingo build --container
cat test_report.txt | go-junit-report > test_report.xml
cat cover.out | sed \'s/code.justin.tv\\/video\\/gotranscoder/\\./g\' > fixed_cover.out
mv -f fixed_cover.out cover.out
mkdir artifact
cp -r bingo-out/primary artifact/bin
'''
		saveDeployArtifact 'video/gotranscoder', 'artifact'
	}
	publishers {
		reportQuality('video/gotranscoder', '.', '*.out')
	}
}

job {
	name 'video-gotranscoder-deploy'
	using 'TEMPLATE-deploy'

	steps {
		downloadDeployArtifact "video/gotranscoder"
		shell 'courier deploy --repo video/gotranscoder --dir /opt/twitch/gotranscoder --skip-restart'
	}
	wrappers {
		credentialsBinding {
			file('AWS_CONFIG_FILE', 'aws_config')
				string 'AWS_ACCESS_KEY_ID', 'core-deploy-artifacts-access-key'
				string 'AWS_SECRET_ACCESS_KEY', 'core-deploy-artifacts-secret-key'
		}
		colorizeOutput()
	}
}
