package config

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

// Setup Data
var cfg Values
var twitchTranscoderStablePath = "/home/jtv/workers/current/avtools/stable/.manta_xenial/installed/bin/TwitchTranscoder"
var twitchTranscoderBetaPath = "/home/jtv/workers/current/avtools/beta/.manta_xenial/installed/bin/TwitchTranscoder"
var testConfig = "../../config/default_config.json"

// Bvts
func TestConfig(t *testing.T) {
	var assert = assert.New(t)
	err := Load(testConfig, &cfg)
	assert.Nil(err)
	assert.Equal(cfg.TwitchTranscoder.PathStable, twitchTranscoderStablePath, "Invalid twitch stable transcoder path")
	assert.Equal(cfg.TwitchTranscoder.PathBeta, twitchTranscoderBetaPath, "Invalid twitch beta transcoder path")
}

// Negative Edge Cases
func TestConfigLoadFileNotFound(t *testing.T) {
	var assert = assert.New(t)
	err := Load("non_existant", &cfg)
	assert.NotNil(err)
}

func TestConfigAccessInvalid(t *testing.T) {
	var assert = assert.New(t)
	err := Load("../../test/data/config/invalid_config.json", &cfg)
	assert.NotNil(err)
}
