package notify

import (
	"errors"
	"testing"

	"github.com/stretchr/testify/assert"

	"code.justin.tv/video/gotranscoder/pkg/notify/fakes"
)

func TestPublish(t *testing.T) {
	assert := assert.New(t)

	svc := &fakes.FakeSNSAPI{}

	s := NewSNS(svc, "test")

	err := s.Publish("fake_msg", "fake_subject", "fake_topic")
	assert.Nil(err)

}

func TestFailedPublish(t *testing.T) {
	assert := assert.New(t)

	svc := &fakes.FakeSNSAPI{}
	svc.PublishReturns(nil, errors.New("fake_error"))

	s := NewSNS(svc, "test")

	err := s.Publish("fake_msg", "fake_subject", "fake_topic")
	assert.NotNil(err)

}
