// +build linux

/*
Signal handling functions for linux builds
*/

package twitchtranscoder

import (
	"os/exec"
	"syscall"
)

// Adds a process signal into a command.
// This till add signals that are only available on linux
func addPdeathsig(cmd *exec.Cmd, signal syscall.Signal) {
	cmd.SysProcAttr = &syscall.SysProcAttr{
		Pdeathsig: signal,
	}
}
