package usher

// DBOption type
type DBOption struct {
	Value interface{}
}

// HlsTranscode Type
type HlsTranscode struct {
	ID                int    `json:"id"`
	JobKey            int    `json:"job_key,omitempty"`
	Channel           string `json:"channel,omitempty"`
	ChannelID         uint64 `json:"channel_id"`
	URI               string `json:"uri,omitempty"`
	Status            string `json:"status,omitempty"`
	Version           int    `json:"version,omitempty"`
	Destination       int    `json:"Destination,omitempty"`
	Configuration     string `json:"configuration,omitempty"`
	Formats           string `json:"formats,omitempty"`
	PushersInfo       string `json:"pushers_info,omitempty"`
	TranscoderInfo    string `json:"transcoder_info,omitempty"`
	LastViewed        int    `json:"last_viewed,omitempty"`
	StartedOn         int    `json:"started_on,omitempty"`
	SessionID         string `json:"session_id,omitempty"`
	OriginFQDN        string `json:"origin_fqdn,omitempty"`
	RenditionMetadata string `json:"rendition_meta,omitempty"`
	TranscodeProfile  string `json:"transcode_profile,omitempty"`
	LvsMetadata       string `json:"lvs_metadata,omitempty"`
}

// StreamInfo Type
type StreamInfo struct {
	ChannelID           int     `json:"channel_id"`
	Origin              int     `json:"origin"`
	Encoder             int     `json:"encoder"`
	UniqueIPCount       int     `json:"unique_ip_count"`
	BroadcastPart       int     `json:"broadcast_part"`
	VideoHeight         int     `json:"video_height"`
	VideoWidth          int     `json:"video_width"`
	DelayLength         int     `json:"delay_length"`
	ChannelViewCount    int     `json:"channel_view_count"`
	Partner             bool    `json:"partner"`
	Ready               bool    `json:"ready"`
	ChannelSubscription bool    `json:"channel_subscription"`
	IphoneRestricted    bool    `json:"iphone_restricted"`
	CdnPreferred        bool    `json:"cdn_preferred"`
	Starved             bool    `json:"starved"`
	AudioBitrate        float32 `json:"audio_bitrate"`
	VideoBitrate        float32 `json:"video_bitrate"`
	Channel             string  `json:"channel"`
	ID                  string  `json:"id"`
	Connect             string  `json:"connect"`
	Uptime              string  `json:"up_time"`
	Platform            string  `json:"platform"`
	AudioCodec          string  `json:"audio_codec"`
	TranscodeFormats    string  `json:"transcode_formats"`
	Rebroadcast         string  `json:"rebroadcast"`
	Category            string  `json:"gaming"`
	Title               string  `json:"Title"`
	Namespace           string  `json:"namespace"`
	SubCategory         string  `json:"subcategory"`
	VideoEncoder        string  `json:"video_encoder"`
	SdkVersion          string  `json:"sdk_version"`
	BroadcastTag        string  `json:"broadcast_tag"`
}

//ChannelStream Type
type ChannelStream struct {
	ID                   int     `json:"id"`
	ChannelID            int     `json:"channel_id"`
	OriginName           int     `json:"origin_name"`
	BroadcastPart        int     `json:"broadcast_part"`
	VideoHeight          int     `json:"video_height"`
	VideoWidth           int     `json:"video_width"`
	Uptime               int     `json:"up_time"`
	DelayLength          int     `json:"delay_length"`
	ChannelViewCount     int     `json:"channel_view_count"`
	AudioBitrate         float32 `json:"audio_bitrate"`
	VideoBitrate         float32 `json:"video_bitrate"`
	Featured             bool    `json:"featured"`
	Unfindable           bool    `json:"unfindable"`
	Partner              bool    `json:"partner"`
	Ready                bool    `json:"ready"`
	IphoneRestricted     bool    `json:"iphone_restricted"`
	InstantReplicate     bool    `json:"instant_replicate"`
	EmbedEnabled         bool    `json:"embed_enabled"`
	AbusedReported       bool    `json:"abuse_reported"`
	Killed               bool    `json:"killed"`
	DirectoryHidden      bool    `json:"directory_hidden"`
	OriginOnly           bool    `json:"origin_only"`
	StreamType           string  `json:"stream_type"`
	ChannelSubscription  string  `json:"channel_subscription"`
	Flows                string  `json:"flows"`
	Geo                  string  `json:"geo"`
	Broadcaster          string  `json:"broadcaster"`
	Rebroadcast          string  `json:"rebroadcast"`
	Category             string  `json:"gaming"`
	Title                string  `json:"Title"`
	Namespace            string  `json:"namespace"`
	SubCategory          string  `json:"subcategory"`
	VideoEncoder         string  `json:"video_encoder"`
	SdkVersion           string  `json:"sdk_version"`
	Experiment           string  `json:"experiment"`
	BroadcastTag         string  `json:"broadcast_tag"`
	Recorder             string  `json:"recorder"`
	Channel              string  `json:"channel"`
	FilteredOn           string  `json:"filtered_on"`
	MetaGame             string  `json:"meta_game"`
	Format               string  `json:"format"`
	VideoRotation        string  `json:"video_rotation"`
	Variant              string  `json:"variant"`
	ArchiveSystemVersion string  `json:"archive_system_version"`
	HlsRatioOverride     string  `json:"hls_ratio_override"`
	CdnPreferred         string  `json:"cdn_preferred"`
	IngestProxy          string  `json:"ingest_proxy"`
	ClientIP             string  `json:"client_ip"`
	Name                 string  `json:"name"`
	Language             string  `json:"language"`
	AudioStreams         string  `json:"audio_streams"`
	CdnWorker            string  `json:"cdn_worker"`
	Persistent           string  `json:"persistent"`
	Starved              string  `json:"starved"`
	CdnRequired          string  `json:"cdn_required"`
	Os                   string  `json:"os"`
	Connect              string  `json:"connect"`
	OriginIP             string  `json:"origin_ip"`
	Value                string  `json:"value"`
}

// StreamCodec is the containerfor the Stream info updates
// Usher ignores empty string fields but not zeroed numbers.
type StreamCodec struct {
	ID                   int     `json:"id,omitempty"`
	Channel              string  `json:"channel,omitempty"`
	ChannelID            uint64  `json:"channel_id,omitempty"`
	VideoCodec           string  `json:"video_codec,omitempty"`
	AudioCodec           string  `json:"audio_codec,omitempty"`
	AvcProfile           string  `json:"avc_profile,omitempty"`
	TargetFps            string  `json:"target_fps,omitempty"`
	Vfr                  string  `json:"vfr,omitempty"`
	AvcLevel             string  `json:"avc_level,omitempty"`
	Channels             int     `json:"channels,omitempty"`
	Width                int     `json:"width,omitempty"`
	Height               int     `json:"height,omitempty"`
	SampleRate           float64 `json:"sample_rate,omitempty"`
	IdrAlignedPercentage float64 `json:"idr_aligned_percent,omitempty"`
	AverageFps           float64 `json:"average_fps,omitempty"`
	AverageKbps          float64 `json:"average_kbps,omitempty"`
	MaxKbps              float64 `json:"max_kbps,omitempty"`
	MaxIdrDelta          float64 `json:"max_idr_delta,omitempty"`
}

// MuxInfo metadata to send to usher
type MuxInfo struct {
	GroupID        string `json:"group_id"`
	DisplayLabel   string `json:"display_label"`
	MuxRate        int    `json:"mux_rate"`
	VideoWidth     int    `json:"video_width"`
	VideoHeight    int    `json:"video_height"`
	Codecs         string `json:"codecs"`
	Fps            int    `json:"fps"`
	MaxIdrInterval int64  `json:"max_idr_interval"`
}
