package usher

// Usher api interface to reach usher
type Usher interface {
	GetShowChannel(channel string) (*HlsTranscode, error)
	GetHlsTranscode(transcodeID int) (*HlsTranscode, error)
	MarkHlsStreamReady(streamid int) error
	SendRabbitJob(key string, vodID int) error
	StreamInfo(channel string) ([]StreamInfo, error)
	KillHlsTranscode(transcodeID int) error
	UpdateStreamProperties(propertyID int, codecInfo interface{}) error
	UpdateHlsEntry(transcodeID int, hlsEntry interface{}) error
	UpdateHlsTranscode(transcodeID int, hlsEntry *HlsTranscode) error
	GetStreamCodec(channel string) (*StreamCodec, error)
	GetDbOption(option string) (*DBOption, error)
}
