package util

import (
	"crypto/md5"
	"encoding/hex"
	"log"
	"math/big"
	"strconv"
)

// GetBase10MD5Hash returns the MD6 hash of a string in base 10 (bigint)
func GetBase10MD5Hash(text string) string {
	hasher := md5.New()
	_, err := hasher.Write([]byte(text))
	if err != nil {
		log.Printf("Error hashing %s - %s", text, err)
	}

	hashString := hex.EncodeToString(hasher.Sum(nil))

	bi := big.NewInt(0)
	bi.SetString(hashString, 16)

	return bi.String()
}

// ConsistentHash returns a capped numeric value based on a string
// resolution is the modulus value to which the hashing will work
// Function returns a value between 0 and 1
func ConsistentHash(text string, resolution int64) float64 {
	bi := big.NewInt(0)
	bi.SetString(GetBase10MD5Hash(text), 10)
	divisor := big.NewInt(resolution)

	val := bi.Mod(bi, divisor)

	value, err := strconv.ParseFloat(val.String(), 64)
	if err != nil {
		return 0
	}

	return value / float64(resolution)
}
