package vod

import (
	"fmt"
	"net/http"
)

// Connection represets a connection to an object store
type Connection interface {
	Put(bucket, objectName string, contents []byte, contentType string) error
	PutNoRetry(bucket, objectName string, contents []byte, contentType string) error
}

// Check if status in the 200s. Returns 'nil' if status is good
func statusOK(resp *http.Response) error {
	if resp.StatusCode >= 200 && resp.StatusCode < 300 {
		return nil
	}
	return fmt.Errorf("Bad response: %s", resp.Status)
}
