package vod

import (
	"testing"

	"strings"

	"fmt"

	"code.justin.tv/video/gotranscoder/pkg/usher"
	"github.com/stretchr/testify/assert"
)

func TestVODManifest(t *testing.T) {
	muxInfo := []usher.MuxInfo{
		{
			GroupID:      "chunked",
			DisplayLabel: "720p60(source)",
			MuxRate:      150000,
			VideoHeight:  720,
			VideoWidth:   1280,
			Codecs:       "avc1.77.31,mp4a.40.2",
			Fps:          60,
		},
		{
			GroupID:      "720p60",
			DisplayLabel: "720p60",
			MuxRate:      120000,
			VideoHeight:  720,
			VideoWidth:   1280,
			Codecs:       "avc1.77.31,mp4a.40.2",
			Fps:          60,
		},
		{
			GroupID:      "480p30",
			DisplayLabel: "720p60(source)",
			MuxRate:      225620,
			VideoHeight:  480,
			VideoWidth:   854,
			Codecs:       "avc1.77.31,mp4a.40.2",
			Fps:          60,
		},
		{
			GroupID:      "audio_only",
			DisplayLabel: "audio_only",
			MuxRate:      1200,
			VideoHeight:  0,
			VideoWidth:   0,
			Codecs:       "mp4a.40.2",
			Fps:          60,
		},
	}

	manifest := string(GenerateVODManifest(muxInfo, "http://test.cloudfront.net", "prefix"))

	assert.True(t, manifest != "")
	manifestData := strings.Split(manifest, "\n")
	//Verify you have more lines in the manifest
	assert.True(t, len(manifestData) > 0)
	//The first line in the manifest has to be the the header
	assert.Equal(t, manifestHeader, manifestData[0])

	index := 1
	for i := 0; i < len(muxInfo); i++ {
		muxRenditonData := muxInfo[i]
		currentRenditonData := manifestData[index]
		currentVariantData := manifestData[index+1]
		currentVariantUrl := manifestData[index+2]
		//Verify all renditon drelated information
		if muxRenditonData.GroupID == AUDIO_ONLY_FORMAT {
			assert.True(t, strings.Contains(currentRenditonData, "TYPE=AUDIO"))
		} else {
			assert.True(t, strings.Contains(currentRenditonData, "TYPE=VIDEO"))
		}

		//Verify auto selected related information
		if muxRenditonData.GroupID == AUDIO_ONLY_FORMAT {
			assert.True(t, strings.Contains(currentRenditonData, "AUTOSELECT=NO"))
		} else {
			assert.True(t, strings.Contains(currentRenditonData, "AUTOSELECT=YES"))
		}

		assert.True(t, strings.Contains(currentRenditonData, fmt.Sprintf("GROUP-ID=\"%s\"", muxRenditonData.GroupID)))
		assert.True(t, strings.Contains(currentRenditonData, fmt.Sprintf("NAME=\"%s\"", muxRenditonData.DisplayLabel)))
		//Verify all variant information
		assert.True(t, strings.Contains(currentVariantData, fmt.Sprintf("BANDWIDTH=%d", muxRenditonData.MuxRate)))
		assert.True(t, strings.Contains(currentVariantData, fmt.Sprintf("CODECS=\"%s\"", muxRenditonData.Codecs)))
		assert.True(t, strings.Contains(currentVariantData, fmt.Sprintf("RESOLUTION=\"%dx%d\"", muxRenditonData.VideoWidth, muxRenditonData.VideoHeight)))
		//Varify the generated variant playlist url
		assert.Equal(t, fmt.Sprintf("http://test.cloudfront.net/prefix/%s/index-dvr.m3u8", muxRenditonData.GroupID), currentVariantUrl)
		index += 3

	}

}
