// +build ignore

package main

import (
	"bytes"
	"crypto/tls"
	"crypto/x509"
	"flag"
	"fmt"
	"io/ioutil"
	"log"
	"net/http"
)

var (
	serverCert = flag.String("server-cert", "", "server public certificate")
	clientCert = flag.String("client-cert", "", "client certificate")
	clientKey  = flag.String("client-key", "", "client key")
	serverUrl  = flag.String("server-url", "", "base url for the lvsapi twirp server")
	contentId  = flag.String("content_id", "", "content id")
)

func main() {
	log.SetFlags(0)
	flag.Parse()

	// Load client cert
	cert, err := tls.LoadX509KeyPair(*clientCert, *clientKey)
	if err != nil {
		log.Fatal("Failed to load client key pair: ", err)
	}

	var certPool *x509.CertPool

	if *serverCert != "" {
		// Load CA cert
		caCert, err := ioutil.ReadFile(*serverCert)
		if err != nil {
			log.Fatal("Failed to read server cert: ", err)
		}
		certPool = x509.NewCertPool()
		certPool.AppendCertsFromPEM(caCert)
	}

	// Setup HTTPS client
	tlsConfig := &tls.Config{
		Certificates: []tls.Certificate{cert},
		RootCAs:      certPool,
	}
	tlsConfig.BuildNameToCertificate()
	transport := &http.Transport{TLSClientConfig: tlsConfig}
	client := &http.Client{Transport: transport}

	url := "https://k7bmf4uxhl.execute-api.us-west-2.amazonaws.com/TestGetStreamLVS/getstream"
	var jsonStr = []byte(`{"content_id": "twitchmedia_lvs_1"}`)
	req, err := http.NewRequest("POST", url, bytes.NewBuffer(jsonStr))
	req.Header.Set("Content-Type", "application/json")
	resp, err := client.Do(req)

	//lvsClient := lvs.NewLiveVideoServiceProtobufClient(*serverUrl, client)
	//resp, err := lvsClient.GetStream(context.Background(), &lvs.GetStreamRequest{
	//	ContentId: *contentId,
	//})
	if err != nil {
		log.Fatal("Twirp error: ", err)
	}

	fmt.Println(resp)
}
