package digestion

import (
	"fmt"
	"net/http"
	"time"

	"golang.org/x/net/context"

	"io"
	"io/ioutil"

	"code.justin.tv/video/lvsapi/internal/httputil"
)

const digestionTimeout = time.Second * 1

//DigestionAPI defines the client which can be used to interact with Digestion
type DigestionAPI struct {
	url    string
	client httputil.HttpClient
}

//NewDigestionAPI returns the client which can be used to query Digestion
func NewDigestionAPI(url string) *DigestionAPI {
	hc := &http.Client{
		Timeout: digestionTimeout,
	}
	return &DigestionAPI{
		url:    url,
		client: hc,
	}
}

//DeleteStream is responsible for calling the delete stream api on digestion which also disconnects rtmp stream
func (d *DigestionAPI) DeleteStream(ctx context.Context, channel string) error {
	if d.client == nil {
		return fmt.Errorf("digestion client is nil")
	}

	url := fmt.Sprintf("http://%s/v1.0/stream/channel_name/%s/disconnect", d.url, channel)
	req, err := http.NewRequest("DELETE", url, nil)
	if err != nil {
		fmt.Println(err)
		return err
	}

	// Fetch Request
	resp, err := d.client.Do(req)
	if err != nil {
		return err
	}

	defer func() {
		if err := resp.Body.Close(); err != nil {
			fmt.Println("Unable to close response body ,", err)
		}
	}()

	_, err = io.Copy(ioutil.Discard, resp.Body)
	if err != nil {
		fmt.Println("Error in reading response body ,", err)
	}

	if resp.StatusCode != http.StatusOK {
		return fmt.Errorf("backend error code:%d", resp.StatusCode)
	}

	return nil
}
