package digestion

import (
	"bytes"
	"io/ioutil"
	"net/http"
	"testing"

	"strings"

	"code.justin.tv/video/lvsapi/internal/httputil/httputilfakes"
	"github.com/stretchr/testify/require"
	"golang.org/x/net/context"
)

func TestDigestionSuccess(t *testing.T) {

	mockHttpClient := httputilfakes.FakeHttpClient{}
	body := `[{"url":"hls_transcode/lvs/amzn_live/test.json" , "type":"error" , "error":"Unauthorized"}]`
	resp := &http.Response{
		Status:        "200 OK",
		StatusCode:    http.StatusOK,
		Proto:         "HTTP/1.1",
		ProtoMajor:    1,
		ProtoMinor:    1,
		Body:          ioutil.NopCloser(bytes.NewBufferString(body)),
		ContentLength: int64(len(body)),
		Request:       &http.Request{},
		Header:        make(http.Header, 0),
	}
	mockHttpClient.DoReturns(resp, nil)

	dgnAPI := DigestionAPI{
		url:    "testUrl",
		client: &mockHttpClient,
	}

	err := dgnAPI.DeleteStream(context.Background(), "channel")
	require.Nil(t, err)

}

func TestDigestionFailure(t *testing.T) {

	mockHttpClient := httputilfakes.FakeHttpClient{}
	body := `[{"url":"hls_transcode/lvs/amzn_live/test.json" , "type":"error" , "error":"Unauthorized"}]`
	resp := &http.Response{
		Status:        "404 Not Found",
		StatusCode:    http.StatusNotFound,
		Proto:         "HTTP/1.1",
		ProtoMajor:    1,
		ProtoMinor:    1,
		Body:          ioutil.NopCloser(bytes.NewBufferString(body)),
		ContentLength: int64(len(body)),
		Request:       &http.Request{},
		Header:        make(http.Header, 0),
	}
	mockHttpClient.DoReturns(resp, nil)

	dgnAPI := DigestionAPI{
		url:    "testUrl",
		client: &mockHttpClient,
	}

	err := dgnAPI.DeleteStream(context.Background(), "channel")
	require.NotNil(t, err)
	require.True(t, strings.Contains(err.Error(), "404"))

}
