package mwsfakes

import (
	"sync"

	"code.justin.tv/commerce/AmazonMWSGoClient/mws"
	"github.com/aws/aws-sdk-go/aws/credentials"
)

// FakeMWSClientInternal is used for accessing/resetting the mock internally
var FakeMWSClientInternal = FakeIAmazonMWSGoClient{}

// FakeMWSClient is the actual mock object that wraps around the generated code
type FakeMWSClient struct{}

// PutMetricsForAggregation wraps around the actual machine generated mock object
func (fake FakeMWSClient) PutMetricsForAggregation(arg1 *mws.PutMetricsForAggregationRequest, arg2 mws.Region, arg3 *credentials.Credentials) (*mws.PutMetricsForAggregationResponse, error) {
	FakeMWSClientInternal.putMetricsForAggregationMutex.Lock()
	ret, specificReturn := FakeMWSClientInternal.putMetricsForAggregationReturnsOnCall[len(FakeMWSClientInternal.putMetricsForAggregationArgsForCall)]
	FakeMWSClientInternal.putMetricsForAggregationArgsForCall = append(FakeMWSClientInternal.putMetricsForAggregationArgsForCall, struct {
		arg1 *mws.PutMetricsForAggregationRequest
		arg2 mws.Region
		arg3 *credentials.Credentials
	}{arg1, arg2, arg3})
	FakeMWSClientInternal.recordInvocation("PutMetricsForAggregation", []interface{}{arg1, arg2, arg3})
	FakeMWSClientInternal.putMetricsForAggregationMutex.Unlock()
	if FakeMWSClientInternal.PutMetricsForAggregationStub != nil {
		return FakeMWSClientInternal.PutMetricsForAggregationStub(arg1, arg2, arg3)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return FakeMWSClientInternal.putMetricsForAggregationReturns.result1, FakeMWSClientInternal.putMetricsForAggregationReturns.result2
}

// FakeIAmazonMWSGoClient is machine generated mock
type FakeIAmazonMWSGoClient struct {
	PutMetricsForAggregationStub        func(*mws.PutMetricsForAggregationRequest, mws.Region, *credentials.Credentials) (*mws.PutMetricsForAggregationResponse, error)
	putMetricsForAggregationMutex       sync.RWMutex
	putMetricsForAggregationArgsForCall []struct {
		arg1 *mws.PutMetricsForAggregationRequest
		arg2 mws.Region
		arg3 *credentials.Credentials
	}
	putMetricsForAggregationReturns struct {
		result1 *mws.PutMetricsForAggregationResponse
		result2 error
	}
	putMetricsForAggregationReturnsOnCall map[int]struct {
		result1 *mws.PutMetricsForAggregationResponse
		result2 error
	}
	invocations      map[string][][]interface{}
	invocationsMutex sync.RWMutex
}

// PutMetricsForAggregation is the mocked call and is machine generated
func (fake *FakeIAmazonMWSGoClient) PutMetricsForAggregation(arg1 *mws.PutMetricsForAggregationRequest, arg2 mws.Region, arg3 *credentials.Credentials) (*mws.PutMetricsForAggregationResponse, error) {
	fake.putMetricsForAggregationMutex.Lock()
	ret, specificReturn := fake.putMetricsForAggregationReturnsOnCall[len(fake.putMetricsForAggregationArgsForCall)]
	fake.putMetricsForAggregationArgsForCall = append(fake.putMetricsForAggregationArgsForCall, struct {
		arg1 *mws.PutMetricsForAggregationRequest
		arg2 mws.Region
		arg3 *credentials.Credentials
	}{arg1, arg2, arg3})
	fake.recordInvocation("PutMetricsForAggregation", []interface{}{arg1, arg2, arg3})
	fake.putMetricsForAggregationMutex.Unlock()
	if fake.PutMetricsForAggregationStub != nil {
		return fake.PutMetricsForAggregationStub(arg1, arg2, arg3)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fake.putMetricsForAggregationReturns.result1, fake.putMetricsForAggregationReturns.result2
}

// PutMetricsForAggregationCallCount tells us how many times PutMetricsForAggregation was called
func (fake *FakeIAmazonMWSGoClient) PutMetricsForAggregationCallCount() int {
	fake.putMetricsForAggregationMutex.RLock()
	defer fake.putMetricsForAggregationMutex.RUnlock()
	return len(fake.putMetricsForAggregationArgsForCall)
}

// PutMetricsForAggregationArgsForCall returns the arguments with which the PutMetricsForAggregation was called on the i-th time, indexed from 0 to n-1
func (fake *FakeIAmazonMWSGoClient) PutMetricsForAggregationArgsForCall(i int) (*mws.PutMetricsForAggregationRequest, mws.Region, *credentials.Credentials) {
	fake.putMetricsForAggregationMutex.RLock()
	defer fake.putMetricsForAggregationMutex.RUnlock()
	return fake.putMetricsForAggregationArgsForCall[i].arg1, fake.putMetricsForAggregationArgsForCall[i].arg2, fake.putMetricsForAggregationArgsForCall[i].arg3
}

// PutMetricsForAggregationReturns tells the mock what PutMetricsForAggregation should return when called
func (fake *FakeIAmazonMWSGoClient) PutMetricsForAggregationReturns(result1 *mws.PutMetricsForAggregationResponse, result2 error) {
	fake.PutMetricsForAggregationStub = nil
	fake.putMetricsForAggregationReturns = struct {
		result1 *mws.PutMetricsForAggregationResponse
		result2 error
	}{result1, result2}
}

// PutMetricsForAggregationReturnsOnCall tells the mock what PutMetricsForAggregation should return when called i-th time, i is indexed from 0 to n-1
func (fake *FakeIAmazonMWSGoClient) PutMetricsForAggregationReturnsOnCall(i int, result1 *mws.PutMetricsForAggregationResponse, result2 error) {
	fake.PutMetricsForAggregationStub = nil
	if fake.putMetricsForAggregationReturnsOnCall == nil {
		fake.putMetricsForAggregationReturnsOnCall = make(map[int]struct {
			result1 *mws.PutMetricsForAggregationResponse
			result2 error
		})
	}
	fake.putMetricsForAggregationReturnsOnCall[i] = struct {
		result1 *mws.PutMetricsForAggregationResponse
		result2 error
	}{result1, result2}
}

// Invocations returns the list of all invocations
func (fake *FakeIAmazonMWSGoClient) Invocations() map[string][][]interface{} {
	fake.invocationsMutex.RLock()
	defer fake.invocationsMutex.RUnlock()
	fake.putMetricsForAggregationMutex.RLock()
	defer fake.putMetricsForAggregationMutex.RUnlock()
	copiedInvocations := map[string][][]interface{}{}
	for key, value := range fake.invocations {
		copiedInvocations[key] = value
	}
	return copiedInvocations
}

func (fake *FakeIAmazonMWSGoClient) recordInvocation(key string, args []interface{}) {
	fake.invocationsMutex.Lock()
	defer fake.invocationsMutex.Unlock()
	if fake.invocations == nil {
		fake.invocations = map[string][][]interface{}{}
	}
	if fake.invocations[key] == nil {
		fake.invocations[key] = [][]interface{}{}
	}
	fake.invocations[key] = append(fake.invocations[key], args)
}

var _ mws.IAmazonMWSGoClient = new(FakeIAmazonMWSGoClient)
