import jenkins.model.Jenkins
import javaposse.jobdsl.dsl.helpers.*
import javaposse.jobdsl.dsl.helpers.step.*

proxy = Jenkins.getInstance().proxy

StepContext.metaClass.uploadVideoBeanstalkApp = { String app, String filename ->
	shell """
aws s3 cp ${filename} s3://elasticbeanstalk-us-west-2-848744099708/apps/${app}/\$GIT_COMMIT.zip
aws elasticbeanstalk create-application-version --region us-west-2 --no-auto-create-application --application-name ${app} --version-label \$GIT_COMMIT --source-bundle S3Bucket=elasticbeanstalk-us-west-2-848744099708,S3Key=apps/${app}/\$GIT_COMMIT.zip
"""
}

StepContext.metaClass.deployVideoBeanstalkApp = { String app ->
	shell """
pip install awsebcli >/dev/null
mkdir -p .elasticbeanstalk
cat > .elasticbeanstalk/config.yml <<EOF
global:
  application_name: ${app}
  default_region: us-west-2
EOF
eb deploy \$ENVIRONMENT --version \$GIT_COMMIT --timeout 1800
"""
}

job {
	name "video-lvsapi"
	using 'TEMPLATE-autobuild'
	wrappers {
		colorizeOutput()
		credentialsBinding {
			string 'AWS_ACCESS_KEY_ID', 'video-aws-access-key'
			string 'AWS_SECRET_ACCESS_KEY', 'video-aws-secret-key'
            		file('AWS_CONFIG_FILE', 'aws_config')
		}
		environmentVariables {
			env('GIT_BRANCH', '${GIT_BRANCH}')
			env('GIT_COMMIT', '${GIT_COMMIT}')
			env('GIT_URL', '${GIT_URL}')
		}
	}
	scm {
		git {
			remote {
				github 'video/lvsapi', 'ssh', 'git-aws.internal.justin.tv'
				credentials 'git-aws-read-key'
			}
			clean true
		}
	}
	steps {
    shell './scripts/jenkins.sh'
    uploadVideoBeanstalkApp 'lvsapi', 'app.zip'
	}
	publishers {
		reportQuality('video/lvsapi', '.', '*.out')
	}
}

job {
	name 'video-lvsapi-deploy'
	using 'TEMPLATE-deploy'
  wrappers {
    credentialsBinding {
      string 'AWS_ACCESS_KEY_ID', 'video-aws-access-key'
      string 'AWS_SECRET_ACCESS_KEY', 'video-aws-secret-key'
    }
  }
	steps {
		deployVideoBeanstalkApp 'lvsapi'
	}
}
