// Code generated by protoc-gen-go. DO NOT EDIT.
// source: lvs.proto

/*
Package lvs is a generated protocol buffer package.

It is generated from these files:
	lvs.proto

It has these top-level messages:
	Stream
	StreamKeyMetadata
	CreateStreamKeyRequest
	CreateStreamKeyResponse
	GetStreamRequest
	GetStreamResponse
	ListStreamsRequest
	ListStreamsResponse
	CheckAuthRequest
	CheckAuthResponse
	AuthorizeBroadcastRequest
	AuthorizeBroadcastResponse
	ResetStreamKeySecretRequest
	ResetStreamKeySecretResponse
	DecodeStreamKeyRequest
	DecodeStreamKeyResponse
	StopStreamRequest
	StopStreamResponse
*/
package lvs

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/timestamp"
import google_protobuf1 "github.com/golang/protobuf/ptypes/wrappers"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// This message represents a single stream in the live video system
type Stream struct {
	// Custom identifier for an individual stream(broadcast)
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId" json:"customer_id,omitempty"`
	// Custom identifier for an individual stream(broadcast)
	ContentId string `protobuf:"bytes,2,opt,name=content_id,json=contentId" json:"content_id,omitempty"`
	// Url to use to playback video for this stream
	CdnPlaybackUrl string `protobuf:"bytes,3,opt,name=cdn_playback_url,json=cdnPlaybackUrl" json:"cdn_playback_url,omitempty"`
	// URL to use to fetch the last generated thumbnail for this stream
	CdnThumbnailUrl string `protobuf:"bytes,4,opt,name=cdn_thumbnail_url,json=cdnThumbnailUrl" json:"cdn_thumbnail_url,omitempty"`
	// RFC3339 timestamp noting when the stream started
	StartTime *google_protobuf.Timestamp `protobuf:"bytes,5,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// Same value as now()-stream_start_time truncated to second accuracy
	DurationSeconds int64 `protobuf:"varint,6,opt,name=duration_seconds,json=durationSeconds" json:"duration_seconds,omitempty"`
	// The current operational state of this stream
	Status string `protobuf:"bytes,7,opt,name=status" json:"status,omitempty"`
	// The current ingestion health of this stream
	HealthStatus string `protobuf:"bytes,8,opt,name=health_status,json=healthStatus" json:"health_status,omitempty"`
	// The reason for the current health status
	HealthReason string `protobuf:"bytes,9,opt,name=health_reason,json=healthReason" json:"health_reason,omitempty"`
	// The s3 folder in which all vods for this session are being stored
	S3VodUrl string `protobuf:"bytes,10,opt,name=s3_vod_url,json=s3VodUrl" json:"s3_vod_url,omitempty"`
	// Current viewer count as seen by the live video system viewcount service
	ViewerCount *google_protobuf1.Int64Value `protobuf:"bytes,11,opt,name=viewer_count,json=viewerCount" json:"viewer_count,omitempty"`
	// The static VOD manifest url
	VodManifestUrl string `protobuf:"bytes,12,opt,name=vod_manifest_url,json=vodManifestUrl" json:"vod_manifest_url,omitempty"`
}

func (m *Stream) Reset()                    { *m = Stream{} }
func (m *Stream) String() string            { return proto.CompactTextString(m) }
func (*Stream) ProtoMessage()               {}
func (*Stream) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Stream) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *Stream) GetContentId() string {
	if m != nil {
		return m.ContentId
	}
	return ""
}

func (m *Stream) GetCdnPlaybackUrl() string {
	if m != nil {
		return m.CdnPlaybackUrl
	}
	return ""
}

func (m *Stream) GetCdnThumbnailUrl() string {
	if m != nil {
		return m.CdnThumbnailUrl
	}
	return ""
}

func (m *Stream) GetStartTime() *google_protobuf.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *Stream) GetDurationSeconds() int64 {
	if m != nil {
		return m.DurationSeconds
	}
	return 0
}

func (m *Stream) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *Stream) GetHealthStatus() string {
	if m != nil {
		return m.HealthStatus
	}
	return ""
}

func (m *Stream) GetHealthReason() string {
	if m != nil {
		return m.HealthReason
	}
	return ""
}

func (m *Stream) GetS3VodUrl() string {
	if m != nil {
		return m.S3VodUrl
	}
	return ""
}

func (m *Stream) GetViewerCount() *google_protobuf1.Int64Value {
	if m != nil {
		return m.ViewerCount
	}
	return nil
}

func (m *Stream) GetVodManifestUrl() string {
	if m != nil {
		return m.VodManifestUrl
	}
	return ""
}

type StreamKeyMetadata struct {
	// destination S3 bucket for vod storage
	S3Bucket string `protobuf:"bytes,1,opt,name=s3_bucket,json=s3Bucket" json:"s3_bucket,omitempty"`
	// SNS topic arn where stream notifications will be sent
	SnsNotificationEndpoint string `protobuf:"bytes,2,opt,name=sns_notification_endpoint,json=snsNotificationEndpoint" json:"sns_notification_endpoint,omitempty"`
	// path prefix where data will be stored in the bucket, relative to root.
	S3Prefix string `protobuf:"bytes,3,opt,name=s3_prefix,json=s3Prefix" json:"s3_prefix,omitempty"`
	// Expiration time for the particualar streamkey
	ExpirationTime *google_protobuf.Timestamp `protobuf:"bytes,4,opt,name=expiration_time,json=expirationTime" json:"expiration_time,omitempty"`
	// cdn Url which will be used in the recorded static manifest
	CdnUrl string `protobuf:"bytes,5,opt,name=cdn_url,json=cdnUrl" json:"cdn_url,omitempty"`
	// Bool value which specifies if low latency transcodes are enabled
	EnableLowLatency bool `protobuf:"varint,6,opt,name=enable_low_latency,json=enableLowLatency" json:"enable_low_latency,omitempty"`
}

func (m *StreamKeyMetadata) Reset()                    { *m = StreamKeyMetadata{} }
func (m *StreamKeyMetadata) String() string            { return proto.CompactTextString(m) }
func (*StreamKeyMetadata) ProtoMessage()               {}
func (*StreamKeyMetadata) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *StreamKeyMetadata) GetS3Bucket() string {
	if m != nil {
		return m.S3Bucket
	}
	return ""
}

func (m *StreamKeyMetadata) GetSnsNotificationEndpoint() string {
	if m != nil {
		return m.SnsNotificationEndpoint
	}
	return ""
}

func (m *StreamKeyMetadata) GetS3Prefix() string {
	if m != nil {
		return m.S3Prefix
	}
	return ""
}

func (m *StreamKeyMetadata) GetExpirationTime() *google_protobuf.Timestamp {
	if m != nil {
		return m.ExpirationTime
	}
	return nil
}

func (m *StreamKeyMetadata) GetCdnUrl() string {
	if m != nil {
		return m.CdnUrl
	}
	return ""
}

func (m *StreamKeyMetadata) GetEnableLowLatency() bool {
	if m != nil {
		return m.EnableLowLatency
	}
	return false
}

// wraps information required to generate an ephemeral video stream key
type CreateStreamKeyRequest struct {
	// Custom identifier for an individual stream(broadcast)
	ContentId string `protobuf:"bytes,1,opt,name=content_id,json=contentId" json:"content_id,omitempty"`
	// destination S3 bucket for vod storage
	S3Bucket string `protobuf:"bytes,2,opt,name=s3_bucket,json=s3Bucket" json:"s3_bucket,omitempty"`
	// SNS topic arn where stream notifications will be sent
	SnsNotificationEndpoint string `protobuf:"bytes,3,opt,name=sns_notification_endpoint,json=snsNotificationEndpoint" json:"sns_notification_endpoint,omitempty"`
	// path prefix where data will be stored in the bucket, relative to root.
	S3Prefix string `protobuf:"bytes,4,opt,name=s3_prefix,json=s3Prefix" json:"s3_prefix,omitempty"`
	// time to live for this given stream key
	TtlSeconds int64 `protobuf:"varint,5,opt,name=ttl_seconds,json=ttlSeconds" json:"ttl_seconds,omitempty"`
	// cdn domain url which will be used to record static vod manifest if present
	CdnUrl string `protobuf:"bytes,6,opt,name=cdn_url,json=cdnUrl" json:"cdn_url,omitempty"`
	// boolean value to specify if want to run in low latency mode
	EnableLowLatency bool `protobuf:"varint,7,opt,name=enable_low_latency,json=enableLowLatency" json:"enable_low_latency,omitempty"`
}

func (m *CreateStreamKeyRequest) Reset()                    { *m = CreateStreamKeyRequest{} }
func (m *CreateStreamKeyRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateStreamKeyRequest) ProtoMessage()               {}
func (*CreateStreamKeyRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *CreateStreamKeyRequest) GetContentId() string {
	if m != nil {
		return m.ContentId
	}
	return ""
}

func (m *CreateStreamKeyRequest) GetS3Bucket() string {
	if m != nil {
		return m.S3Bucket
	}
	return ""
}

func (m *CreateStreamKeyRequest) GetSnsNotificationEndpoint() string {
	if m != nil {
		return m.SnsNotificationEndpoint
	}
	return ""
}

func (m *CreateStreamKeyRequest) GetS3Prefix() string {
	if m != nil {
		return m.S3Prefix
	}
	return ""
}

func (m *CreateStreamKeyRequest) GetTtlSeconds() int64 {
	if m != nil {
		return m.TtlSeconds
	}
	return 0
}

func (m *CreateStreamKeyRequest) GetCdnUrl() string {
	if m != nil {
		return m.CdnUrl
	}
	return ""
}

func (m *CreateStreamKeyRequest) GetEnableLowLatency() bool {
	if m != nil {
		return m.EnableLowLatency
	}
	return false
}

// Container for generated ephemeral stream key
type CreateStreamKeyResponse struct {
	// Full url to use to ingest a video session
	RtmpIngestUrl string `protobuf:"bytes,1,opt,name=rtmp_ingest_url,json=rtmpIngestUrl" json:"rtmp_ingest_url,omitempty"`
	// full url to use to playback the given content
	PlaybackUrl string `protobuf:"bytes,2,opt,name=playback_url,json=playbackUrl" json:"playback_url,omitempty"`
	// The RTMP server to send the stream to
	RtmpServer string `protobuf:"bytes,3,opt,name=rtmp_server,json=rtmpServer" json:"rtmp_server,omitempty"`
	// The streamkey to be used for sending data
	Streamkey string `protobuf:"bytes,4,opt,name=streamkey" json:"streamkey,omitempty"`
	// The Customer ID who is associated with the streamkey
	CustomerId string `protobuf:"bytes,5,opt,name=customer_id,json=customerId" json:"customer_id,omitempty"`
	// Custom identifier for an individual stream(broadcast)
	ContentId string `protobuf:"bytes,6,opt,name=content_id,json=contentId" json:"content_id,omitempty"`
	// The data which was sent as part of the CreateStreamKey request
	StreamkeyMetadata *StreamKeyMetadata `protobuf:"bytes,7,opt,name=streamkey_metadata,json=streamkeyMetadata" json:"streamkey_metadata,omitempty"`
}

func (m *CreateStreamKeyResponse) Reset()                    { *m = CreateStreamKeyResponse{} }
func (m *CreateStreamKeyResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateStreamKeyResponse) ProtoMessage()               {}
func (*CreateStreamKeyResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *CreateStreamKeyResponse) GetRtmpIngestUrl() string {
	if m != nil {
		return m.RtmpIngestUrl
	}
	return ""
}

func (m *CreateStreamKeyResponse) GetPlaybackUrl() string {
	if m != nil {
		return m.PlaybackUrl
	}
	return ""
}

func (m *CreateStreamKeyResponse) GetRtmpServer() string {
	if m != nil {
		return m.RtmpServer
	}
	return ""
}

func (m *CreateStreamKeyResponse) GetStreamkey() string {
	if m != nil {
		return m.Streamkey
	}
	return ""
}

func (m *CreateStreamKeyResponse) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *CreateStreamKeyResponse) GetContentId() string {
	if m != nil {
		return m.ContentId
	}
	return ""
}

func (m *CreateStreamKeyResponse) GetStreamkeyMetadata() *StreamKeyMetadata {
	if m != nil {
		return m.StreamkeyMetadata
	}
	return nil
}

// Parameters for function call to help fetch metadata around a video stream
type GetStreamRequest struct {
	// Custom identifier for an individual stream(broadcast)
	ContentId string `protobuf:"bytes,1,opt,name=content_id,json=contentId" json:"content_id,omitempty"`
}

func (m *GetStreamRequest) Reset()                    { *m = GetStreamRequest{} }
func (m *GetStreamRequest) String() string            { return proto.CompactTextString(m) }
func (*GetStreamRequest) ProtoMessage()               {}
func (*GetStreamRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *GetStreamRequest) GetContentId() string {
	if m != nil {
		return m.ContentId
	}
	return ""
}

// Container with the information about a given stream session
type GetStreamResponse struct {
	Stream *Stream `protobuf:"bytes,1,opt,name=stream" json:"stream,omitempty"`
}

func (m *GetStreamResponse) Reset()                    { *m = GetStreamResponse{} }
func (m *GetStreamResponse) String() string            { return proto.CompactTextString(m) }
func (*GetStreamResponse) ProtoMessage()               {}
func (*GetStreamResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *GetStreamResponse) GetStream() *Stream {
	if m != nil {
		return m.Stream
	}
	return nil
}

type ListStreamsRequest struct {
	// The type of the stream( 'all' , 'live' , 'starting' ) for the given customer
	Type string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
}

func (m *ListStreamsRequest) Reset()                    { *m = ListStreamsRequest{} }
func (m *ListStreamsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListStreamsRequest) ProtoMessage()               {}
func (*ListStreamsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *ListStreamsRequest) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

type ListStreamsResponse struct {
	Streams []*Stream `protobuf:"bytes,1,rep,name=streams" json:"streams,omitempty"`
}

func (m *ListStreamsResponse) Reset()                    { *m = ListStreamsResponse{} }
func (m *ListStreamsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListStreamsResponse) ProtoMessage()               {}
func (*ListStreamsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *ListStreamsResponse) GetStreams() []*Stream {
	if m != nil {
		return m.Streams
	}
	return nil
}

type CheckAuthRequest struct {
}

func (m *CheckAuthRequest) Reset()                    { *m = CheckAuthRequest{} }
func (m *CheckAuthRequest) String() string            { return proto.CompactTextString(m) }
func (*CheckAuthRequest) ProtoMessage()               {}
func (*CheckAuthRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

// Response from the auth check
type CheckAuthResponse struct {
	// Custom identifier for an individual stream(broadcast)
	LvsCustomerId string `protobuf:"bytes,1,opt,name=lvs_customer_id,json=lvsCustomerId" json:"lvs_customer_id,omitempty"`
}

func (m *CheckAuthResponse) Reset()                    { *m = CheckAuthResponse{} }
func (m *CheckAuthResponse) String() string            { return proto.CompactTextString(m) }
func (*CheckAuthResponse) ProtoMessage()               {}
func (*CheckAuthResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *CheckAuthResponse) GetLvsCustomerId() string {
	if m != nil {
		return m.LvsCustomerId
	}
	return ""
}

type AuthorizeBroadcastRequest struct {
	Streamkey string `protobuf:"bytes,1,opt,name=streamkey" json:"streamkey,omitempty"`
}

func (m *AuthorizeBroadcastRequest) Reset()                    { *m = AuthorizeBroadcastRequest{} }
func (m *AuthorizeBroadcastRequest) String() string            { return proto.CompactTextString(m) }
func (*AuthorizeBroadcastRequest) ProtoMessage()               {}
func (*AuthorizeBroadcastRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *AuthorizeBroadcastRequest) GetStreamkey() string {
	if m != nil {
		return m.Streamkey
	}
	return ""
}

type AuthorizeBroadcastResponse struct {
	// Custom identifier for an individual stream(broadcast)
	ContentId string `protobuf:"bytes,1,opt,name=content_id,json=contentId" json:"content_id,omitempty"`
	// destination S3 bucket for vod storage
	S3Bucket string `protobuf:"bytes,2,opt,name=s3_bucket,json=s3Bucket" json:"s3_bucket,omitempty"`
	// SNS topic arn where stream notifications will be sent
	SnsNotificationEndpoint string `protobuf:"bytes,3,opt,name=sns_notification_endpoint,json=snsNotificationEndpoint" json:"sns_notification_endpoint,omitempty"`
	// path prefix where data will be stored in the bucket, relative to root.
	S3Prefix string `protobuf:"bytes,4,opt,name=s3_prefix,json=s3Prefix" json:"s3_prefix,omitempty"`
	// Custom identifier for the customer
	CustomerId string `protobuf:"bytes,5,opt,name=customer_id,json=customerId" json:"customer_id,omitempty"`
	// LVS Channel Name
	ChannelName string `protobuf:"bytes,6,opt,name=channel_name,json=channelName" json:"channel_name,omitempty"`
	// cdn url to be used for recording static VOD manifest
	CdnUrl string `protobuf:"bytes,7,opt,name=cdn_url,json=cdnUrl" json:"cdn_url,omitempty"`
	// boolean value which indicates if low latency stack is enabled
	LowLatency bool `protobuf:"varint,8,opt,name=low_latency,json=lowLatency" json:"low_latency,omitempty"`
}

func (m *AuthorizeBroadcastResponse) Reset()                    { *m = AuthorizeBroadcastResponse{} }
func (m *AuthorizeBroadcastResponse) String() string            { return proto.CompactTextString(m) }
func (*AuthorizeBroadcastResponse) ProtoMessage()               {}
func (*AuthorizeBroadcastResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *AuthorizeBroadcastResponse) GetContentId() string {
	if m != nil {
		return m.ContentId
	}
	return ""
}

func (m *AuthorizeBroadcastResponse) GetS3Bucket() string {
	if m != nil {
		return m.S3Bucket
	}
	return ""
}

func (m *AuthorizeBroadcastResponse) GetSnsNotificationEndpoint() string {
	if m != nil {
		return m.SnsNotificationEndpoint
	}
	return ""
}

func (m *AuthorizeBroadcastResponse) GetS3Prefix() string {
	if m != nil {
		return m.S3Prefix
	}
	return ""
}

func (m *AuthorizeBroadcastResponse) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *AuthorizeBroadcastResponse) GetChannelName() string {
	if m != nil {
		return m.ChannelName
	}
	return ""
}

func (m *AuthorizeBroadcastResponse) GetCdnUrl() string {
	if m != nil {
		return m.CdnUrl
	}
	return ""
}

func (m *AuthorizeBroadcastResponse) GetLowLatency() bool {
	if m != nil {
		return m.LowLatency
	}
	return false
}

type ResetStreamKeySecretRequest struct {
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId" json:"customer_id,omitempty"`
}

func (m *ResetStreamKeySecretRequest) Reset()                    { *m = ResetStreamKeySecretRequest{} }
func (m *ResetStreamKeySecretRequest) String() string            { return proto.CompactTextString(m) }
func (*ResetStreamKeySecretRequest) ProtoMessage()               {}
func (*ResetStreamKeySecretRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *ResetStreamKeySecretRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

type ResetStreamKeySecretResponse struct {
}

func (m *ResetStreamKeySecretResponse) Reset()                    { *m = ResetStreamKeySecretResponse{} }
func (m *ResetStreamKeySecretResponse) String() string            { return proto.CompactTextString(m) }
func (*ResetStreamKeySecretResponse) ProtoMessage()               {}
func (*ResetStreamKeySecretResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

type DecodeStreamKeyRequest struct {
	// streamkey to be decoded
	Streamkey string `protobuf:"bytes,1,opt,name=streamkey" json:"streamkey,omitempty"`
}

func (m *DecodeStreamKeyRequest) Reset()                    { *m = DecodeStreamKeyRequest{} }
func (m *DecodeStreamKeyRequest) String() string            { return proto.CompactTextString(m) }
func (*DecodeStreamKeyRequest) ProtoMessage()               {}
func (*DecodeStreamKeyRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *DecodeStreamKeyRequest) GetStreamkey() string {
	if m != nil {
		return m.Streamkey
	}
	return ""
}

type DecodeStreamKeyResponse struct {
	// The customer to whom the streamkey belongs , only if decoding is succesful
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId" json:"customer_id,omitempty"`
	// Custom identifier for an individual stream(broadcast)
	ContentId string `protobuf:"bytes,2,opt,name=content_id,json=contentId" json:"content_id,omitempty"`
	// The decoded streamkey metadata
	StreamkeyMetadata *StreamKeyMetadata `protobuf:"bytes,3,opt,name=streamkey_metadata,json=streamkeyMetadata" json:"streamkey_metadata,omitempty"`
}

func (m *DecodeStreamKeyResponse) Reset()                    { *m = DecodeStreamKeyResponse{} }
func (m *DecodeStreamKeyResponse) String() string            { return proto.CompactTextString(m) }
func (*DecodeStreamKeyResponse) ProtoMessage()               {}
func (*DecodeStreamKeyResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *DecodeStreamKeyResponse) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *DecodeStreamKeyResponse) GetContentId() string {
	if m != nil {
		return m.ContentId
	}
	return ""
}

func (m *DecodeStreamKeyResponse) GetStreamkeyMetadata() *StreamKeyMetadata {
	if m != nil {
		return m.StreamkeyMetadata
	}
	return nil
}

type StopStreamRequest struct {
	// Custom identifier for an individual stream(broadcast)
	ContentId string `protobuf:"bytes,1,opt,name=content_id,json=contentId" json:"content_id,omitempty"`
}

func (m *StopStreamRequest) Reset()                    { *m = StopStreamRequest{} }
func (m *StopStreamRequest) String() string            { return proto.CompactTextString(m) }
func (*StopStreamRequest) ProtoMessage()               {}
func (*StopStreamRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *StopStreamRequest) GetContentId() string {
	if m != nil {
		return m.ContentId
	}
	return ""
}

type StopStreamResponse struct {
}

func (m *StopStreamResponse) Reset()                    { *m = StopStreamResponse{} }
func (m *StopStreamResponse) String() string            { return proto.CompactTextString(m) }
func (*StopStreamResponse) ProtoMessage()               {}
func (*StopStreamResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func init() {
	proto.RegisterType((*Stream)(nil), "lvs.Stream")
	proto.RegisterType((*StreamKeyMetadata)(nil), "lvs.StreamKeyMetadata")
	proto.RegisterType((*CreateStreamKeyRequest)(nil), "lvs.CreateStreamKeyRequest")
	proto.RegisterType((*CreateStreamKeyResponse)(nil), "lvs.CreateStreamKeyResponse")
	proto.RegisterType((*GetStreamRequest)(nil), "lvs.GetStreamRequest")
	proto.RegisterType((*GetStreamResponse)(nil), "lvs.GetStreamResponse")
	proto.RegisterType((*ListStreamsRequest)(nil), "lvs.ListStreamsRequest")
	proto.RegisterType((*ListStreamsResponse)(nil), "lvs.ListStreamsResponse")
	proto.RegisterType((*CheckAuthRequest)(nil), "lvs.CheckAuthRequest")
	proto.RegisterType((*CheckAuthResponse)(nil), "lvs.CheckAuthResponse")
	proto.RegisterType((*AuthorizeBroadcastRequest)(nil), "lvs.AuthorizeBroadcastRequest")
	proto.RegisterType((*AuthorizeBroadcastResponse)(nil), "lvs.AuthorizeBroadcastResponse")
	proto.RegisterType((*ResetStreamKeySecretRequest)(nil), "lvs.ResetStreamKeySecretRequest")
	proto.RegisterType((*ResetStreamKeySecretResponse)(nil), "lvs.ResetStreamKeySecretResponse")
	proto.RegisterType((*DecodeStreamKeyRequest)(nil), "lvs.DecodeStreamKeyRequest")
	proto.RegisterType((*DecodeStreamKeyResponse)(nil), "lvs.DecodeStreamKeyResponse")
	proto.RegisterType((*StopStreamRequest)(nil), "lvs.StopStreamRequest")
	proto.RegisterType((*StopStreamResponse)(nil), "lvs.StopStreamResponse")
}

func init() { proto.RegisterFile("lvs.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 1104 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x57, 0x5f, 0x4f, 0x1b, 0x47,
	0x10, 0x97, 0x31, 0x18, 0x7b, 0x0e, 0x82, 0xd9, 0xa6, 0xd8, 0x31, 0x14, 0xc3, 0x45, 0xad, 0x68,
	0x55, 0x11, 0x15, 0x57, 0x51, 0x43, 0xdb, 0xa8, 0x85, 0x46, 0x15, 0x0a, 0x89, 0x22, 0x13, 0x78,
	0x68, 0x1f, 0x4e, 0xeb, 0xbb, 0x01, 0x4e, 0x9c, 0x77, 0xaf, 0xbb, 0x7b, 0x26, 0xee, 0xf7, 0xe8,
	0x7b, 0xdf, 0x2a, 0xf5, 0xa5, 0xdf, 0xa4, 0x1f, 0xa5, 0x9f, 0xa1, 0xda, 0xbd, 0x3d, 0xff, 0xb9,
	0x33, 0x10, 0xd4, 0x97, 0xbe, 0x71, 0xbf, 0x99, 0xd9, 0x9d, 0xf9, 0xcd, 0x6f, 0x66, 0x0d, 0xd4,
	0xa2, 0x81, 0xdc, 0x8d, 0x05, 0x57, 0x9c, 0x94, 0xa3, 0x81, 0x6c, 0xb5, 0x2f, 0x38, 0xbf, 0x88,
	0xf0, 0x89, 0x81, 0x7a, 0xc9, 0xf9, 0x13, 0x15, 0xf6, 0x51, 0x2a, 0xda, 0x8f, 0x53, 0xaf, 0xd6,
	0x66, 0xde, 0xe1, 0x5a, 0xd0, 0x38, 0x46, 0x61, 0x4f, 0x71, 0xff, 0x29, 0x43, 0xe5, 0x44, 0x09,
	0xa4, 0x7d, 0xd2, 0x06, 0xc7, 0x4f, 0xa4, 0xe2, 0x7d, 0x14, 0x5e, 0x18, 0x34, 0x4b, 0x5b, 0xa5,
	0x9d, 0x5a, 0x17, 0x32, 0xe8, 0x28, 0x20, 0x1f, 0x01, 0xf8, 0x9c, 0x29, 0x64, 0x4a, 0xdb, 0xe7,
	0x8c, 0xbd, 0x66, 0x91, 0xa3, 0x80, 0xec, 0x40, 0xdd, 0x0f, 0x98, 0x17, 0x47, 0x74, 0xd8, 0xa3,
	0xfe, 0x95, 0x97, 0x88, 0xa8, 0x59, 0x36, 0x4e, 0x0f, 0xfc, 0x80, 0xbd, 0xb1, 0xf0, 0xa9, 0x88,
	0xc8, 0x67, 0xb0, 0xaa, 0x3d, 0xd5, 0x65, 0xd2, 0xef, 0x31, 0x1a, 0x46, 0xc6, 0x75, 0xde, 0xb8,
	0xae, 0xf8, 0x01, 0x7b, 0x9b, 0xe1, 0xda, 0xf7, 0x19, 0x80, 0x54, 0x54, 0x28, 0x4f, 0x57, 0xd6,
	0x5c, 0xd8, 0x2a, 0xed, 0x38, 0x7b, 0xad, 0xdd, 0xb4, 0xaa, 0xdd, 0xac, 0xaa, 0xdd, 0xb7, 0x59,
	0xd9, 0xdd, 0x9a, 0xf1, 0xd6, 0xdf, 0xe4, 0x53, 0xa8, 0x07, 0x89, 0xa0, 0x2a, 0xe4, 0xcc, 0x93,
	0xe8, 0x73, 0x16, 0xc8, 0x66, 0x65, 0xab, 0xb4, 0x53, 0xee, 0xae, 0x64, 0xf8, 0x49, 0x0a, 0x93,
	0x35, 0xa8, 0x48, 0x45, 0x55, 0x22, 0x9b, 0x8b, 0x26, 0x0d, 0xfb, 0x45, 0x1e, 0xc3, 0xf2, 0x25,
	0xd2, 0x48, 0x5d, 0x7a, 0xd6, 0x5c, 0x35, 0xe6, 0xa5, 0x14, 0x3c, 0xc9, 0x3b, 0x09, 0xa4, 0x92,
	0xb3, 0x66, 0x6d, 0xd2, 0xa9, 0x6b, 0x30, 0xb2, 0x01, 0x20, 0x3b, 0xde, 0x80, 0x07, 0xa6, 0x58,
	0x30, 0x1e, 0x55, 0xd9, 0x39, 0xe3, 0x81, 0xae, 0xf2, 0x39, 0x2c, 0x0d, 0x42, 0xbc, 0x46, 0xe1,
	0xf9, 0x3c, 0x61, 0xaa, 0xe9, 0x98, 0x3a, 0xd7, 0x0b, 0x75, 0x1e, 0x31, 0xf5, 0xf4, 0xcb, 0x33,
	0x1a, 0x25, 0xd8, 0x75, 0xd2, 0x80, 0x43, 0xed, 0xaf, 0xb9, 0xd7, 0x47, 0xf7, 0x29, 0x0b, 0xcf,
	0x51, 0x2a, 0x73, 0xc7, 0x52, 0xca, 0xfd, 0x80, 0x07, 0xaf, 0x2c, 0x7c, 0x2a, 0x22, 0xf7, 0xb7,
	0x39, 0x58, 0x4d, 0x1b, 0xfe, 0x12, 0x87, 0xaf, 0x50, 0xd1, 0x80, 0x2a, 0x4a, 0xd6, 0xa1, 0x26,
	0x3b, 0x5e, 0x2f, 0xf1, 0xaf, 0x50, 0xd9, 0xce, 0x57, 0x65, 0xe7, 0xc0, 0x7c, 0x93, 0x7d, 0x78,
	0x24, 0x99, 0xf4, 0x18, 0x57, 0xe1, 0x79, 0xe8, 0xa7, 0x7c, 0x22, 0x0b, 0x62, 0x1e, 0x32, 0x65,
	0x65, 0xd0, 0x90, 0x4c, 0xbe, 0x9e, 0xb0, 0xbf, 0xb0, 0x66, 0x7b, 0x70, 0x2c, 0xf0, 0x3c, 0x7c,
	0x67, 0xd5, 0x50, 0x95, 0x9d, 0x37, 0xe6, 0x9b, 0x1c, 0xc2, 0x0a, 0xbe, 0x8b, 0x43, 0xdb, 0x22,
	0xd3, 0xe0, 0xf9, 0x3b, 0x1b, 0xfc, 0x60, 0x1c, 0x62, 0xba, 0xdc, 0x80, 0x45, 0x2d, 0x26, 0x5d,
	0xf1, 0x42, 0xda, 0x3b, 0x3f, 0x60, 0x9a, 0xd3, 0xcf, 0x81, 0x20, 0xa3, 0xbd, 0x08, 0xbd, 0x88,
	0x5f, 0x7b, 0x11, 0x55, 0xc8, 0xfc, 0xa1, 0x11, 0x40, 0xb5, 0x5b, 0x4f, 0x2d, 0xc7, 0xfc, 0xfa,
	0x38, 0xc5, 0x35, 0x2f, 0x6b, 0x87, 0x02, 0xa9, 0xc2, 0x11, 0x3b, 0x5d, 0xfc, 0x25, 0x41, 0xa9,
	0x72, 0xba, 0x2f, 0xe5, 0x75, 0x3f, 0xc5, 0xdd, 0xdc, 0x7d, 0xb8, 0x2b, 0xdf, 0x83, 0xbb, 0xf9,
	0x1c, 0x77, 0x6d, 0x70, 0x94, 0x8a, 0x46, 0xba, 0x5e, 0x30, 0xba, 0x06, 0xa5, 0xa2, 0x4c, 0xd2,
	0x13, 0xbc, 0x54, 0xde, 0x83, 0x97, 0xc5, 0x1b, 0x78, 0xf9, 0x73, 0x0e, 0x1a, 0x05, 0x5e, 0x64,
	0xcc, 0x99, 0x44, 0xf2, 0x09, 0xac, 0x08, 0xd5, 0x8f, 0xbd, 0x90, 0x5d, 0x64, 0xa2, 0x4b, 0xd9,
	0x59, 0xd6, 0xf0, 0x91, 0x41, 0xf5, 0x8d, 0xdb, 0xb0, 0x34, 0xb5, 0x15, 0x52, 0x92, 0x9c, 0x78,
	0x62, 0x25, 0xb4, 0xc1, 0x31, 0x47, 0x49, 0x14, 0x03, 0x14, 0x96, 0x19, 0xd0, 0xd0, 0x89, 0x41,
	0xc8, 0x06, 0xd4, 0xa4, 0x49, 0xe0, 0x0a, 0x87, 0x96, 0x8c, 0x31, 0x90, 0xdf, 0x5d, 0x0b, 0x77,
	0xec, 0xae, 0x4a, 0xbe, 0x87, 0x2f, 0x80, 0x8c, 0x0e, 0xf3, 0xfa, 0x76, 0x2a, 0x0c, 0x27, 0xce,
	0xde, 0xda, 0xae, 0x5e, 0xba, 0x85, 0x99, 0xe9, 0xae, 0x8e, 0x22, 0x32, 0xc8, 0xfd, 0x02, 0xea,
	0x3f, 0xa2, 0x4a, 0x5d, 0xdf, 0x4f, 0x3d, 0xee, 0x57, 0xb0, 0x3a, 0x11, 0x62, 0x89, 0x7d, 0xac,
	0xd7, 0x91, 0x46, 0x8c, 0xbf, 0xb3, 0xe7, 0x4c, 0xa4, 0xd0, 0xb5, 0x26, 0x77, 0x07, 0xc8, 0x71,
	0x28, 0x6d, 0xa8, 0xcc, 0xae, 0x23, 0x30, 0xaf, 0x86, 0x31, 0xda, 0x8b, 0xcc, 0xdf, 0xee, 0x37,
	0xf0, 0xc1, 0x94, 0xa7, 0xbd, 0xe5, 0x63, 0x58, 0x4c, 0x8f, 0x92, 0xcd, 0xd2, 0x56, 0x39, 0x7f,
	0x4d, 0x66, 0x73, 0x09, 0xd4, 0x0f, 0x2f, 0xd1, 0xbf, 0xfa, 0x3e, 0xd1, 0xcb, 0xcc, 0xdc, 0xe2,
	0x7e, 0x0d, 0xab, 0x13, 0xd8, 0x58, 0x0e, 0xd1, 0x40, 0x7a, 0xc5, 0x47, 0x64, 0x39, 0x1a, 0xc8,
	0xc3, 0x51, 0x2f, 0xdc, 0x67, 0xf0, 0x48, 0xc7, 0x71, 0x11, 0xfe, 0x8a, 0x07, 0x82, 0xd3, 0xc0,
	0xa7, 0x52, 0x65, 0xf9, 0x4f, 0xf5, 0xb9, 0x94, 0xeb, 0xb3, 0xfb, 0xd7, 0x1c, 0xb4, 0x66, 0xc5,
	0xda, 0x0c, 0xfe, 0xaf, 0x93, 0x7a, 0xbb, 0x36, 0xb7, 0x61, 0xc9, 0xbf, 0xa4, 0x8c, 0x61, 0xe4,
	0x31, 0xda, 0x47, 0xab, 0x4e, 0xc7, 0x62, 0xaf, 0xe9, 0xf4, 0x92, 0x5b, 0x9c, 0x1a, 0xe6, 0x36,
	0x38, 0x93, 0x53, 0x5c, 0x35, 0x53, 0x0c, 0xd1, 0x78, 0x7e, 0x9f, 0xc3, 0x7a, 0x17, 0x65, 0xa6,
	0xb0, 0x97, 0x38, 0x3c, 0x41, 0x5f, 0xe0, 0x88, 0xee, 0xbb, 0x1e, 0x7d, 0x77, 0x13, 0x36, 0x66,
	0xc7, 0xa7, 0x94, 0xbb, 0x4f, 0x61, 0xed, 0x07, 0xf4, 0x79, 0x50, 0x5c, 0x9b, 0xb7, 0x77, 0xf2,
	0xf7, 0x12, 0x34, 0x0a, 0x81, 0xb6, 0x8d, 0xff, 0xf5, 0x97, 0xc8, 0xec, 0x69, 0x2e, 0xdf, 0x77,
	0x9a, 0xf7, 0xf4, 0x4b, 0xc9, 0xe3, 0x7b, 0x8d, 0xf3, 0x43, 0x20, 0x93, 0x31, 0x69, 0x41, 0x7b,
	0x7f, 0x97, 0xa0, 0x79, 0x1c, 0x0e, 0xf0, 0x2c, 0x0c, 0x90, 0xeb, 0x85, 0x16, 0xfa, 0x78, 0xc4,
	0x14, 0x0a, 0x46, 0x23, 0x72, 0x0a, 0xa4, 0x28, 0x69, 0xb2, 0x69, 0xf2, 0xbc, 0x71, 0x4e, 0x5a,
	0xed, 0x1b, 0xed, 0x96, 0xc4, 0x9f, 0xe1, 0xe1, 0xac, 0xc6, 0x91, 0x2d, 0x13, 0x78, 0x8b, 0x26,
	0x5a, 0xdb, 0xb7, 0x78, 0xd8, 0x82, 0xfe, 0x28, 0x43, 0x3d, 0x5f, 0x10, 0xd9, 0x87, 0xda, 0x68,
	0x29, 0x90, 0x0f, 0xcd, 0x21, 0xf9, 0xc5, 0xd1, 0x5a, 0xcb, 0xc3, 0x36, 0xdb, 0x63, 0x58, 0xc9,
	0xbd, 0x32, 0x64, 0x3d, 0x75, 0x9d, 0xf9, 0x26, 0xb7, 0x36, 0x66, 0x1b, 0xed, 0x69, 0xfb, 0x50,
	0x1b, 0x2d, 0x55, 0x9b, 0x49, 0x7e, 0x2f, 0xdb, 0x4c, 0x8a, 0xbb, 0xf7, 0x3b, 0x70, 0x26, 0x96,
	0x25, 0x69, 0x18, 0xb7, 0xe2, 0xa2, 0x6d, 0x35, 0x8b, 0x86, 0x71, 0x2d, 0x39, 0x65, 0xdb, 0x5a,
	0x66, 0x0f, 0x8a, 0xad, 0xe5, 0xa6, 0x61, 0xf8, 0x16, 0x60, 0xac, 0x28, 0x92, 0xc9, 0x37, 0x27,
	0xcb, 0x56, 0xa3, 0x80, 0xa7, 0xe1, 0x07, 0x0b, 0x3f, 0xe9, 0x7f, 0x14, 0x7a, 0x15, 0xf3, 0x4b,
	0xaa, 0xf3, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x4c, 0x43, 0xb6, 0x57, 0x41, 0x0c, 0x00, 0x00,
}
