// Code generated by protoc-gen-twirp v4.6.0, DO NOT EDIT.
// source: lvs.proto

/*
Package lvs is a generated twirp stub package.
This code was generated with code.justin.tv/common/twirp/protoc-gen-twirp v4.6.0.

It is generated from these files:
	lvs.proto
*/
package lvs

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/golang/protobuf/ptypes/timestamp"
import _ "github.com/golang/protobuf/ptypes/wrappers"

import bytes "bytes"
import strconv "strconv"
import context "golang.org/x/net/context"
import http "net/http"
import ioutil "io/ioutil"
import jsonpb "github.com/golang/protobuf/jsonpb"
import log "log"
import proto1 "github.com/golang/protobuf/proto"
import twirp "code.justin.tv/common/twirp"
import fmt1 "fmt"

// Imports only used by utility functions:
import io "io"
import strings "strings"
import json "encoding/json"
import url "net/url"
import ctxhttp "golang.org/x/net/context/ctxhttp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// ==================================
// LiveVideoServiceInternal Interface
// ==================================

type LiveVideoServiceInternal interface {
	// Authorizes streamkey and returns decoded streamkey on success
	AuthorizeBroadcast(context.Context, *AuthorizeBroadcastRequest) (*AuthorizeBroadcastResponse, error)

	// Resets the secret used to encrypt/decrypt stream keys for a given customer
	ResetStreamKeySecret(context.Context, *ResetStreamKeySecretRequest) (*ResetStreamKeySecretResponse, error)
}

// ========================================
// LiveVideoServiceInternal Protobuf Client
// ========================================

type liveVideoServiceInternalProtobufClient struct {
	urlBase string
	client  *http.Client
}

// NewLiveVideoServiceInternalProtobufClient creates a Protobuf client that implements the LiveVideoServiceInternal interface.
// It communicates using protobuf messages and can be configured with a custom http.Client.
func NewLiveVideoServiceInternalProtobufClient(addr string, client *http.Client) LiveVideoServiceInternal {
	return &liveVideoServiceInternalProtobufClient{
		urlBase: urlBase(addr),
		client:  withoutRedirects(client),
	}
}

func (c *liveVideoServiceInternalProtobufClient) AuthorizeBroadcast(ctx context.Context, in *AuthorizeBroadcastRequest) (*AuthorizeBroadcastResponse, error) {
	url := c.urlBase + LiveVideoServiceInternalPathPrefix + "AuthorizeBroadcast"
	out := new(AuthorizeBroadcastResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *liveVideoServiceInternalProtobufClient) ResetStreamKeySecret(ctx context.Context, in *ResetStreamKeySecretRequest) (*ResetStreamKeySecretResponse, error) {
	url := c.urlBase + LiveVideoServiceInternalPathPrefix + "ResetStreamKeySecret"
	out := new(ResetStreamKeySecretResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

// ====================================
// LiveVideoServiceInternal JSON Client
// ====================================

type liveVideoServiceInternalJSONClient struct {
	urlBase string
	client  *http.Client
}

// NewLiveVideoServiceInternalJSONClient creates a JSON client that implements the LiveVideoServiceInternal interface.
// It communicates using JSON requests and responses instead of protobuf messages.
func NewLiveVideoServiceInternalJSONClient(addr string, client *http.Client) LiveVideoServiceInternal {
	return &liveVideoServiceInternalJSONClient{
		urlBase: urlBase(addr),
		client:  withoutRedirects(client),
	}
}

func (c *liveVideoServiceInternalJSONClient) AuthorizeBroadcast(ctx context.Context, in *AuthorizeBroadcastRequest) (*AuthorizeBroadcastResponse, error) {
	url := c.urlBase + LiveVideoServiceInternalPathPrefix + "AuthorizeBroadcast"
	out := new(AuthorizeBroadcastResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *liveVideoServiceInternalJSONClient) ResetStreamKeySecret(ctx context.Context, in *ResetStreamKeySecretRequest) (*ResetStreamKeySecretResponse, error) {
	url := c.urlBase + LiveVideoServiceInternalPathPrefix + "ResetStreamKeySecret"
	out := new(ResetStreamKeySecretResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

// =======================================
// LiveVideoServiceInternal Server Handler
// =======================================

type liveVideoServiceInternalServer struct {
	LiveVideoServiceInternal
	hooks     *twirp.ServerHooks
	ctxSource ContextSource
}

func NewLiveVideoServiceInternalServer(svc LiveVideoServiceInternal, hooks *twirp.ServerHooks, ctxSrc ContextSource) TwirpServer {
	defaultHooks := twirp.NewServerHooks()
	if hooks == nil {
		hooks = defaultHooks
	} else {
		if hooks.RequestReceived == nil {
			hooks.RequestReceived = defaultHooks.RequestReceived
		}
		if hooks.RequestRouted == nil {
			hooks.RequestRouted = defaultHooks.RequestRouted
		}
		if hooks.ResponsePrepared == nil {
			hooks.ResponsePrepared = defaultHooks.ResponsePrepared
		}
		if hooks.ResponseSent == nil {
			hooks.ResponseSent = defaultHooks.ResponseSent
		}
		if hooks.Error == nil {
			hooks.Error = defaultHooks.Error
		}
	}
	if ctxSrc == nil {
		ctxSrc = RequestContextSource
	}

	return &liveVideoServiceInternalServer{
		LiveVideoServiceInternal: svc,
		hooks:     hooks,
		ctxSource: ctxSrc,
	}
}

// LiveVideoServiceInternalPathPrefix is used for all URL paths on a twirp LiveVideoServiceInternal server.
// Requests are always: POST LiveVideoServiceInternalPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const LiveVideoServiceInternalPathPrefix = "/twirp/lvs.LiveVideoServiceInternal/"

// LiveVideoServiceInternalPathPrefixOld is used to handle requests from v2 Clients.
// If you are using an HTTP mux, please handle this routes as well to upgrade from v2 to v3.
const LiveVideoServiceInternalPathPrefixOld = "/v2/lvs.LiveVideoServiceInternal/"

func (s *liveVideoServiceInternalServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := s.ctxSource(resp, req)
	ctx = setServerName(ctx, "LiveVideoServiceInternal")
	ctx = setVersionFromPath(ctx, req.URL.Path)
	ctx = context.WithValue(ctx, "__tw_response_writer", resp) // for SetHTTPResponseHeader
	ctx = s.hooks.RequestReceived(ctx)

	if req.Method != "POST" {
		msg := fmt1.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.serveError(ctx, resp, req, twerr)
		return
	}

	switch req.URL.Path {
	case LiveVideoServiceInternalPathPrefix + "AuthorizeBroadcast", LiveVideoServiceInternalPathPrefixOld + "AuthorizeBroadcast", "/v1/LiveVideoServiceInternal/AuthorizeBroadcast":
		s.serveAuthorizeBroadcast(ctx, resp, req)
		return
	case LiveVideoServiceInternalPathPrefix + "ResetStreamKeySecret", LiveVideoServiceInternalPathPrefixOld + "ResetStreamKeySecret", "/v1/LiveVideoServiceInternal/ResetStreamKeySecret":
		s.serveResetStreamKeySecret(ctx, resp, req)
		return
	default:
		msg := fmt1.Sprintf("no handler for path %q", req.URL.Path)
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.serveError(ctx, resp, req, twerr)
		return
	}
}

// Make HTTP response from an error.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *liveVideoServiceInternalServer) serveError(ctx context.Context, resp http.ResponseWriter, req *http.Request, err error) {
	// When handling v2 client requests, serve backwards-compatible error responses
	if version := getVersion(ctx); version == "v1" || version == "v2" {
		s.serveErrorV1V2(ctx, resp, req, err)
	} else {
		s.serveErrorV3Plus(ctx, resp, req, err)
	}
}

// v3+ error responses.
func (s *liveVideoServiceInternalServer) serveErrorV3Plus(ctx context.Context, resp http.ResponseWriter, req *http.Request, err error) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = setStatusCode(ctx, statusCode)
	ctx = s.hooks.Error(ctx, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, err2 := resp.Write(respBody)
	if err2 != nil {
		log.Printf("unable to send error message %q: %s", twerr, err2)
	}
	_ = s.hooks.ResponseSent(ctx)
}

// v1/v2 backwards-compatible error responses.
// To make it easy to upgrade to v3, a v3 server keeps serving v2-style errors to v2 clients.
func (s *liveVideoServiceInternalServer) serveErrorV1V2(ctx context.Context, resp http.ResponseWriter, req *http.Request, err error) {
	// Non-twirp errors are wrapped as Unknown 500 (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.NewError(twirp.Unknown, err.Error())
	}

	resp.Header().Set("Content-Type", "text/plain")

	// v2err.Retryable <= v3err.Meta("retryable")
	if twerr.Meta("retryable") != "" {
		resp.Header().Set("Twirp-Error-Retryable", "true")
	}

	// v2err.ErrorID <= v3err.Meta("v2_error_id") if present, otherwise v3err.Code()
	// or "unroutable" if generated from twirp router (BadRoute)
	var v2ErrorID string
	if twerr.Code() == twirp.BadRoute {
		v2ErrorID = "unroutable" // as was generated by previous router
	} else if twerr.Meta("v2_error_id") != "" {
		v2ErrorID = twerr.Meta("v2_error_id")
	} else {
		v2ErrorID = string(twerr.Code()) // the string-format of v3 codes match v2 error ids for the most part: i.e. "not_found", "internal", "unknown", "canceled", etc.
	}
	resp.Header().Set("Twirp-ErrorID", v2ErrorID)

	// v2err.StatusCode <= v3err.Meta("v2_status_code") if present, otherwise same as in v3
	statusCode, err := strconv.Atoi(twerr.Meta("v2_status_code"))
	if err != nil {
		statusCode = twirp.ServerHTTPStatusFromErrorCode(twerr.Code()) // v3 it's the same as v2 for the most part: i.e. "not_found" is 404
	}
	ctx = setStatusCode(ctx, statusCode)
	ctx = s.hooks.Error(ctx, twerr)
	resp.WriteHeader(statusCode)

	msg := []byte(twerr.Msg())
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}
	_, err2 := resp.Write(msg)
	if err2 != nil {
		log.Printf("unable to send error message %q: %s", twerr, err2)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *liveVideoServiceInternalServer) serveAuthorizeBroadcast(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveAuthorizeBroadcastJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAuthorizeBroadcastProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *liveVideoServiceInternalServer) serveAuthorizeBroadcastJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "AuthorizeBroadcast")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(AuthorizeBroadcastRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AuthorizeBroadcastResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AuthorizeBroadcast(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *AuthorizeBroadcastResponse and nil error while calling AuthorizeBroadcast. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *liveVideoServiceInternalServer) serveAuthorizeBroadcastProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "AuthorizeBroadcast")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(AuthorizeBroadcastRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AuthorizeBroadcastResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AuthorizeBroadcast(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *AuthorizeBroadcastResponse and nil error while calling AuthorizeBroadcast. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *liveVideoServiceInternalServer) serveResetStreamKeySecret(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveResetStreamKeySecretJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveResetStreamKeySecretProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *liveVideoServiceInternalServer) serveResetStreamKeySecretJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "ResetStreamKeySecret")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(ResetStreamKeySecretRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ResetStreamKeySecretResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ResetStreamKeySecret(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *ResetStreamKeySecretResponse and nil error while calling ResetStreamKeySecret. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *liveVideoServiceInternalServer) serveResetStreamKeySecretProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "ResetStreamKeySecret")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ResetStreamKeySecretRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ResetStreamKeySecretResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ResetStreamKeySecret(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *ResetStreamKeySecretResponse and nil error while calling ResetStreamKeySecret. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *liveVideoServiceInternalServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *liveVideoServiceInternalServer) ProtocGenTwirpVersion() string {
	return "v4.6.0"
}

// ==========================
// LiveVideoService Interface
// ==========================

type LiveVideoService interface {
	CheckAuth(context.Context, *CheckAuthRequest) (*CheckAuthResponse, error)

	// Creates a signed ephemeral stream key to broadcast an LVS channel
	CreateStreamKey(context.Context, *CreateStreamKeyRequest) (*CreateStreamKeyResponse, error)

	// Retrieves information about an existing LVS ephemeral stream
	GetStream(context.Context, *GetStreamRequest) (*GetStreamResponse, error)

	// Returns a list of all streams for a given customer
	ListStreams(context.Context, *ListStreamsRequest) (*ListStreamsResponse, error)

	// Decodes a given streamkey and returns all relevant information if successful
	DecodeStreamKey(context.Context, *DecodeStreamKeyRequest) (*DecodeStreamKeyResponse, error)

	// Stop Stream can be used to disconnect rtmp and stop transcoding, viewers will not be able to view the stream
	StopStream(context.Context, *StopStreamRequest) (*StopStreamResponse, error)
}

// ================================
// LiveVideoService Protobuf Client
// ================================

type liveVideoServiceProtobufClient struct {
	urlBase string
	client  *http.Client
}

// NewLiveVideoServiceProtobufClient creates a Protobuf client that implements the LiveVideoService interface.
// It communicates using protobuf messages and can be configured with a custom http.Client.
func NewLiveVideoServiceProtobufClient(addr string, client *http.Client) LiveVideoService {
	return &liveVideoServiceProtobufClient{
		urlBase: urlBase(addr),
		client:  withoutRedirects(client),
	}
}

func (c *liveVideoServiceProtobufClient) CheckAuth(ctx context.Context, in *CheckAuthRequest) (*CheckAuthResponse, error) {
	url := c.urlBase + LiveVideoServicePathPrefix + "CheckAuth"
	out := new(CheckAuthResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *liveVideoServiceProtobufClient) CreateStreamKey(ctx context.Context, in *CreateStreamKeyRequest) (*CreateStreamKeyResponse, error) {
	url := c.urlBase + LiveVideoServicePathPrefix + "CreateStreamKey"
	out := new(CreateStreamKeyResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *liveVideoServiceProtobufClient) GetStream(ctx context.Context, in *GetStreamRequest) (*GetStreamResponse, error) {
	url := c.urlBase + LiveVideoServicePathPrefix + "GetStream"
	out := new(GetStreamResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *liveVideoServiceProtobufClient) ListStreams(ctx context.Context, in *ListStreamsRequest) (*ListStreamsResponse, error) {
	url := c.urlBase + LiveVideoServicePathPrefix + "ListStreams"
	out := new(ListStreamsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *liveVideoServiceProtobufClient) DecodeStreamKey(ctx context.Context, in *DecodeStreamKeyRequest) (*DecodeStreamKeyResponse, error) {
	url := c.urlBase + LiveVideoServicePathPrefix + "DecodeStreamKey"
	out := new(DecodeStreamKeyResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *liveVideoServiceProtobufClient) StopStream(ctx context.Context, in *StopStreamRequest) (*StopStreamResponse, error) {
	url := c.urlBase + LiveVideoServicePathPrefix + "StopStream"
	out := new(StopStreamResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

// ============================
// LiveVideoService JSON Client
// ============================

type liveVideoServiceJSONClient struct {
	urlBase string
	client  *http.Client
}

// NewLiveVideoServiceJSONClient creates a JSON client that implements the LiveVideoService interface.
// It communicates using JSON requests and responses instead of protobuf messages.
func NewLiveVideoServiceJSONClient(addr string, client *http.Client) LiveVideoService {
	return &liveVideoServiceJSONClient{
		urlBase: urlBase(addr),
		client:  withoutRedirects(client),
	}
}

func (c *liveVideoServiceJSONClient) CheckAuth(ctx context.Context, in *CheckAuthRequest) (*CheckAuthResponse, error) {
	url := c.urlBase + LiveVideoServicePathPrefix + "CheckAuth"
	out := new(CheckAuthResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *liveVideoServiceJSONClient) CreateStreamKey(ctx context.Context, in *CreateStreamKeyRequest) (*CreateStreamKeyResponse, error) {
	url := c.urlBase + LiveVideoServicePathPrefix + "CreateStreamKey"
	out := new(CreateStreamKeyResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *liveVideoServiceJSONClient) GetStream(ctx context.Context, in *GetStreamRequest) (*GetStreamResponse, error) {
	url := c.urlBase + LiveVideoServicePathPrefix + "GetStream"
	out := new(GetStreamResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *liveVideoServiceJSONClient) ListStreams(ctx context.Context, in *ListStreamsRequest) (*ListStreamsResponse, error) {
	url := c.urlBase + LiveVideoServicePathPrefix + "ListStreams"
	out := new(ListStreamsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *liveVideoServiceJSONClient) DecodeStreamKey(ctx context.Context, in *DecodeStreamKeyRequest) (*DecodeStreamKeyResponse, error) {
	url := c.urlBase + LiveVideoServicePathPrefix + "DecodeStreamKey"
	out := new(DecodeStreamKeyResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *liveVideoServiceJSONClient) StopStream(ctx context.Context, in *StopStreamRequest) (*StopStreamResponse, error) {
	url := c.urlBase + LiveVideoServicePathPrefix + "StopStream"
	out := new(StopStreamResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

// ===============================
// LiveVideoService Server Handler
// ===============================

type liveVideoServiceServer struct {
	LiveVideoService
	hooks     *twirp.ServerHooks
	ctxSource ContextSource
}

func NewLiveVideoServiceServer(svc LiveVideoService, hooks *twirp.ServerHooks, ctxSrc ContextSource) TwirpServer {
	defaultHooks := twirp.NewServerHooks()
	if hooks == nil {
		hooks = defaultHooks
	} else {
		if hooks.RequestReceived == nil {
			hooks.RequestReceived = defaultHooks.RequestReceived
		}
		if hooks.RequestRouted == nil {
			hooks.RequestRouted = defaultHooks.RequestRouted
		}
		if hooks.ResponsePrepared == nil {
			hooks.ResponsePrepared = defaultHooks.ResponsePrepared
		}
		if hooks.ResponseSent == nil {
			hooks.ResponseSent = defaultHooks.ResponseSent
		}
		if hooks.Error == nil {
			hooks.Error = defaultHooks.Error
		}
	}
	if ctxSrc == nil {
		ctxSrc = RequestContextSource
	}

	return &liveVideoServiceServer{
		LiveVideoService: svc,
		hooks:            hooks,
		ctxSource:        ctxSrc,
	}
}

// LiveVideoServicePathPrefix is used for all URL paths on a twirp LiveVideoService server.
// Requests are always: POST LiveVideoServicePathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const LiveVideoServicePathPrefix = "/twirp/lvs.LiveVideoService/"

// LiveVideoServicePathPrefixOld is used to handle requests from v2 Clients.
// If you are using an HTTP mux, please handle this routes as well to upgrade from v2 to v3.
const LiveVideoServicePathPrefixOld = "/v2/lvs.LiveVideoService/"

func (s *liveVideoServiceServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := s.ctxSource(resp, req)
	ctx = setServerName(ctx, "LiveVideoService")
	ctx = setVersionFromPath(ctx, req.URL.Path)
	ctx = context.WithValue(ctx, "__tw_response_writer", resp) // for SetHTTPResponseHeader
	ctx = s.hooks.RequestReceived(ctx)

	if req.Method != "POST" {
		msg := fmt1.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.serveError(ctx, resp, req, twerr)
		return
	}

	switch req.URL.Path {
	case LiveVideoServicePathPrefix + "CheckAuth", LiveVideoServicePathPrefixOld + "CheckAuth", "/v1/LiveVideoService/CheckAuth":
		s.serveCheckAuth(ctx, resp, req)
		return
	case LiveVideoServicePathPrefix + "CreateStreamKey", LiveVideoServicePathPrefixOld + "CreateStreamKey", "/v1/LiveVideoService/CreateStreamKey":
		s.serveCreateStreamKey(ctx, resp, req)
		return
	case LiveVideoServicePathPrefix + "GetStream", LiveVideoServicePathPrefixOld + "GetStream", "/v1/LiveVideoService/GetStream":
		s.serveGetStream(ctx, resp, req)
		return
	case LiveVideoServicePathPrefix + "ListStreams", LiveVideoServicePathPrefixOld + "ListStreams", "/v1/LiveVideoService/ListStreams":
		s.serveListStreams(ctx, resp, req)
		return
	case LiveVideoServicePathPrefix + "DecodeStreamKey", LiveVideoServicePathPrefixOld + "DecodeStreamKey", "/v1/LiveVideoService/DecodeStreamKey":
		s.serveDecodeStreamKey(ctx, resp, req)
		return
	case LiveVideoServicePathPrefix + "StopStream", LiveVideoServicePathPrefixOld + "StopStream", "/v1/LiveVideoService/StopStream":
		s.serveStopStream(ctx, resp, req)
		return
	default:
		msg := fmt1.Sprintf("no handler for path %q", req.URL.Path)
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.serveError(ctx, resp, req, twerr)
		return
	}
}

// Make HTTP response from an error.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *liveVideoServiceServer) serveError(ctx context.Context, resp http.ResponseWriter, req *http.Request, err error) {
	// When handling v2 client requests, serve backwards-compatible error responses
	if version := getVersion(ctx); version == "v1" || version == "v2" {
		s.serveErrorV1V2(ctx, resp, req, err)
	} else {
		s.serveErrorV3Plus(ctx, resp, req, err)
	}
}

// v3+ error responses.
func (s *liveVideoServiceServer) serveErrorV3Plus(ctx context.Context, resp http.ResponseWriter, req *http.Request, err error) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = setStatusCode(ctx, statusCode)
	ctx = s.hooks.Error(ctx, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, err2 := resp.Write(respBody)
	if err2 != nil {
		log.Printf("unable to send error message %q: %s", twerr, err2)
	}
	_ = s.hooks.ResponseSent(ctx)
}

// v1/v2 backwards-compatible error responses.
// To make it easy to upgrade to v3, a v3 server keeps serving v2-style errors to v2 clients.
func (s *liveVideoServiceServer) serveErrorV1V2(ctx context.Context, resp http.ResponseWriter, req *http.Request, err error) {
	// Non-twirp errors are wrapped as Unknown 500 (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.NewError(twirp.Unknown, err.Error())
	}

	resp.Header().Set("Content-Type", "text/plain")

	// v2err.Retryable <= v3err.Meta("retryable")
	if twerr.Meta("retryable") != "" {
		resp.Header().Set("Twirp-Error-Retryable", "true")
	}

	// v2err.ErrorID <= v3err.Meta("v2_error_id") if present, otherwise v3err.Code()
	// or "unroutable" if generated from twirp router (BadRoute)
	var v2ErrorID string
	if twerr.Code() == twirp.BadRoute {
		v2ErrorID = "unroutable" // as was generated by previous router
	} else if twerr.Meta("v2_error_id") != "" {
		v2ErrorID = twerr.Meta("v2_error_id")
	} else {
		v2ErrorID = string(twerr.Code()) // the string-format of v3 codes match v2 error ids for the most part: i.e. "not_found", "internal", "unknown", "canceled", etc.
	}
	resp.Header().Set("Twirp-ErrorID", v2ErrorID)

	// v2err.StatusCode <= v3err.Meta("v2_status_code") if present, otherwise same as in v3
	statusCode, err := strconv.Atoi(twerr.Meta("v2_status_code"))
	if err != nil {
		statusCode = twirp.ServerHTTPStatusFromErrorCode(twerr.Code()) // v3 it's the same as v2 for the most part: i.e. "not_found" is 404
	}
	ctx = setStatusCode(ctx, statusCode)
	ctx = s.hooks.Error(ctx, twerr)
	resp.WriteHeader(statusCode)

	msg := []byte(twerr.Msg())
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}
	_, err2 := resp.Write(msg)
	if err2 != nil {
		log.Printf("unable to send error message %q: %s", twerr, err2)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *liveVideoServiceServer) serveCheckAuth(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCheckAuthJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCheckAuthProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *liveVideoServiceServer) serveCheckAuthJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CheckAuth")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CheckAuthRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CheckAuthResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CheckAuth(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *CheckAuthResponse and nil error while calling CheckAuth. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *liveVideoServiceServer) serveCheckAuthProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CheckAuth")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CheckAuthRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CheckAuthResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CheckAuth(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *CheckAuthResponse and nil error while calling CheckAuth. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *liveVideoServiceServer) serveCreateStreamKey(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCreateStreamKeyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateStreamKeyProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *liveVideoServiceServer) serveCreateStreamKeyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateStreamKey")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CreateStreamKeyRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateStreamKeyResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateStreamKey(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *CreateStreamKeyResponse and nil error while calling CreateStreamKey. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *liveVideoServiceServer) serveCreateStreamKeyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateStreamKey")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateStreamKeyRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateStreamKeyResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateStreamKey(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *CreateStreamKeyResponse and nil error while calling CreateStreamKey. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *liveVideoServiceServer) serveGetStream(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetStreamJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetStreamProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *liveVideoServiceServer) serveGetStreamJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetStream")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetStreamRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetStreamResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetStream(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetStreamResponse and nil error while calling GetStream. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *liveVideoServiceServer) serveGetStreamProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetStream")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetStreamRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetStreamResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetStream(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *GetStreamResponse and nil error while calling GetStream. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *liveVideoServiceServer) serveListStreams(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveListStreamsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListStreamsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *liveVideoServiceServer) serveListStreamsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "ListStreams")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(ListStreamsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListStreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListStreams(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *ListStreamsResponse and nil error while calling ListStreams. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *liveVideoServiceServer) serveListStreamsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "ListStreams")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListStreamsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListStreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListStreams(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *ListStreamsResponse and nil error while calling ListStreams. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *liveVideoServiceServer) serveDecodeStreamKey(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveDecodeStreamKeyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDecodeStreamKeyProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *liveVideoServiceServer) serveDecodeStreamKeyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "DecodeStreamKey")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(DecodeStreamKeyRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DecodeStreamKeyResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DecodeStreamKey(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *DecodeStreamKeyResponse and nil error while calling DecodeStreamKey. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *liveVideoServiceServer) serveDecodeStreamKeyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "DecodeStreamKey")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DecodeStreamKeyRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DecodeStreamKeyResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DecodeStreamKey(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *DecodeStreamKeyResponse and nil error while calling DecodeStreamKey. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *liveVideoServiceServer) serveStopStream(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveStopStreamJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveStopStreamProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.serveError(ctx, resp, req, twerr)
	}
}

func (s *liveVideoServiceServer) serveStopStreamJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "StopStream")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(StopStreamRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StopStreamResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.StopStream(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *StopStreamResponse and nil error while calling StopStream. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *liveVideoServiceServer) serveStopStreamProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "StopStream")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(StopStreamRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StopStreamResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.serveError(ctx, resp, req, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.StopStream(ctx, reqContent)
	}()

	if err != nil {
		s.serveError(ctx, resp, req, err)
		return
	}
	if respContent == nil {
		s.serveError(ctx, resp, req, twirp.InternalError("received a nil *StopStreamResponse and nil error while calling StopStream. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.serveError(ctx, resp, req, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *liveVideoServiceServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 1
}

func (s *liveVideoServiceServer) ProtocGenTwirpVersion() string {
	return "v4.6.0"
}

// =====
// Utils
// =====

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshaled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// A ContextSource establishes the base context for a Server.
type ContextSource func(http.ResponseWriter, *http.Request) context.Context

var RequestContextSource ContextSource = func(w http.ResponseWriter, req *http.Request) context.Context {
	return req.Context()
}

var BackgroundContextSource ContextSource = func(http.ResponseWriter, *http.Request) context.Context {
	return context.Background()
}

// done returns ctx.Err() if ctx.Done() indicates that the context done
func done(ctx context.Context) error {
	select {
	case <-ctx.Done():
		return ctx.Err()
	default:
		return nil
	}
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// setMethodName, setServerName, and setStatusCode are functions to
// expose internal state through contexts. The context keys hardcoded
// in here are not to be used on their own. Twirp provides accessor
// functions which will retrieve these values out and give them the
// correct type for you.
func setMethodName(ctx context.Context, name string) context.Context {
	return context.WithValue(ctx, "__tw_method_name", name)
}
func setServerName(ctx context.Context, name string) context.Context {
	return context.WithValue(ctx, "__tw_service_name", name)
}
func setStatusCode(ctx context.Context, code int) context.Context {
	return context.WithValue(ctx, "__tw_status_code", strconv.Itoa(code))
}

type privateContextKey int

var versionKey = new(privateContextKey)

// setVersionFromPath adds "v1", "v2" or "v3" to the context depending on the path.
func setVersionFromPath(ctx context.Context, path string) context.Context {
	var version string
	if strings.HasPrefix(path, "/v1/") {
		version = "v1"
	} else if strings.HasPrefix(path, "/v2/") {
		version = "v2"
	} else {
		version = "v3"
	}
	return context.WithValue(ctx, versionKey, version)
}

// getVersion returns the version number ("v1", "v2", "v3") or empty string if unset.
func getVersion(ctx context.Context) string {
	v, _ := ctx.Value(versionKey).(string)
	return v
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := ctx.Value("__tw_request_header").(http.Header)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// closebody closes a response or request body and just logs
// any error encountered while closing, since errors are
// considered very unusual.
func closebody(body io.Closer) {
	if err := body.Close(); err != nil {
		log.Printf("error closing body: %q", err)
	}
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v4.6.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients dont't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt1.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt1.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtoRequest is common code to make a request to the remote twirp service.
func doProtoRequest(ctx context.Context, client *http.Client, url string, in, out proto1.Message) error {
	var err error
	reqBodyBytes, err := proto1.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := ctxhttp.Do(ctx, client, req)
	if err != nil {
		return clientError("failed to do request", err)
	}
	defer closebody(resp.Body)
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto1.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client *http.Client, url string, in, out proto1.Message) error {
	var err error
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := ctxhttp.Do(ctx, client, req)
	if err != nil {
		return clientError("failed to do request", err)
	}
	defer closebody(resp.Body)
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

var twirpFileDescriptor0 = []byte{
	// 1104 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x57, 0x5f, 0x4f, 0x1b, 0x47,
	0x10, 0x97, 0x31, 0x18, 0x7b, 0x0e, 0x82, 0xd9, 0xa6, 0xd8, 0x31, 0x14, 0xc3, 0x45, 0xad, 0x68,
	0x55, 0x11, 0x15, 0x57, 0x51, 0x43, 0xdb, 0xa8, 0x85, 0x46, 0x15, 0x0a, 0x89, 0x22, 0x13, 0x78,
	0x68, 0x1f, 0x4e, 0xeb, 0xbb, 0x01, 0x4e, 0x9c, 0x77, 0xaf, 0xbb, 0x7b, 0x26, 0xee, 0xf7, 0xe8,
	0x7b, 0xdf, 0x2a, 0xf5, 0xa5, 0xdf, 0xa4, 0x1f, 0xa5, 0x9f, 0xa1, 0xda, 0xbd, 0x3d, 0xff, 0xb9,
	0x33, 0x10, 0xd4, 0x97, 0xbe, 0x71, 0xbf, 0x99, 0xd9, 0x9d, 0xf9, 0xcd, 0x6f, 0x66, 0x0d, 0xd4,
	0xa2, 0x81, 0xdc, 0x8d, 0x05, 0x57, 0x9c, 0x94, 0xa3, 0x81, 0x6c, 0xb5, 0x2f, 0x38, 0xbf, 0x88,
	0xf0, 0x89, 0x81, 0x7a, 0xc9, 0xf9, 0x13, 0x15, 0xf6, 0x51, 0x2a, 0xda, 0x8f, 0x53, 0xaf, 0xd6,
	0x66, 0xde, 0xe1, 0x5a, 0xd0, 0x38, 0x46, 0x61, 0x4f, 0x71, 0xff, 0x29, 0x43, 0xe5, 0x44, 0x09,
	0xa4, 0x7d, 0xd2, 0x06, 0xc7, 0x4f, 0xa4, 0xe2, 0x7d, 0x14, 0x5e, 0x18, 0x34, 0x4b, 0x5b, 0xa5,
	0x9d, 0x5a, 0x17, 0x32, 0xe8, 0x28, 0x20, 0x1f, 0x01, 0xf8, 0x9c, 0x29, 0x64, 0x4a, 0xdb, 0xe7,
	0x8c, 0xbd, 0x66, 0x91, 0xa3, 0x80, 0xec, 0x40, 0xdd, 0x0f, 0x98, 0x17, 0x47, 0x74, 0xd8, 0xa3,
	0xfe, 0x95, 0x97, 0x88, 0xa8, 0x59, 0x36, 0x4e, 0x0f, 0xfc, 0x80, 0xbd, 0xb1, 0xf0, 0xa9, 0x88,
	0xc8, 0x67, 0xb0, 0xaa, 0x3d, 0xd5, 0x65, 0xd2, 0xef, 0x31, 0x1a, 0x46, 0xc6, 0x75, 0xde, 0xb8,
	0xae, 0xf8, 0x01, 0x7b, 0x9b, 0xe1, 0xda, 0xf7, 0x19, 0x80, 0x54, 0x54, 0x28, 0x4f, 0x57, 0xd6,
	0x5c, 0xd8, 0x2a, 0xed, 0x38, 0x7b, 0xad, 0xdd, 0xb4, 0xaa, 0xdd, 0xac, 0xaa, 0xdd, 0xb7, 0x59,
	0xd9, 0xdd, 0x9a, 0xf1, 0xd6, 0xdf, 0xe4, 0x53, 0xa8, 0x07, 0x89, 0xa0, 0x2a, 0xe4, 0xcc, 0x93,
	0xe8, 0x73, 0x16, 0xc8, 0x66, 0x65, 0xab, 0xb4, 0x53, 0xee, 0xae, 0x64, 0xf8, 0x49, 0x0a, 0x93,
	0x35, 0xa8, 0x48, 0x45, 0x55, 0x22, 0x9b, 0x8b, 0x26, 0x0d, 0xfb, 0x45, 0x1e, 0xc3, 0xf2, 0x25,
	0xd2, 0x48, 0x5d, 0x7a, 0xd6, 0x5c, 0x35, 0xe6, 0xa5, 0x14, 0x3c, 0xc9, 0x3b, 0x09, 0xa4, 0x92,
	0xb3, 0x66, 0x6d, 0xd2, 0xa9, 0x6b, 0x30, 0xb2, 0x01, 0x20, 0x3b, 0xde, 0x80, 0x07, 0xa6, 0x58,
	0x30, 0x1e, 0x55, 0xd9, 0x39, 0xe3, 0x81, 0xae, 0xf2, 0x39, 0x2c, 0x0d, 0x42, 0xbc, 0x46, 0xe1,
	0xf9, 0x3c, 0x61, 0xaa, 0xe9, 0x98, 0x3a, 0xd7, 0x0b, 0x75, 0x1e, 0x31, 0xf5, 0xf4, 0xcb, 0x33,
	0x1a, 0x25, 0xd8, 0x75, 0xd2, 0x80, 0x43, 0xed, 0xaf, 0xb9, 0xd7, 0x47, 0xf7, 0x29, 0x0b, 0xcf,
	0x51, 0x2a, 0x73, 0xc7, 0x52, 0xca, 0xfd, 0x80, 0x07, 0xaf, 0x2c, 0x7c, 0x2a, 0x22, 0xf7, 0xb7,
	0x39, 0x58, 0x4d, 0x1b, 0xfe, 0x12, 0x87, 0xaf, 0x50, 0xd1, 0x80, 0x2a, 0x4a, 0xd6, 0xa1, 0x26,
	0x3b, 0x5e, 0x2f, 0xf1, 0xaf, 0x50, 0xd9, 0xce, 0x57, 0x65, 0xe7, 0xc0, 0x7c, 0x93, 0x7d, 0x78,
	0x24, 0x99, 0xf4, 0x18, 0x57, 0xe1, 0x79, 0xe8, 0xa7, 0x7c, 0x22, 0x0b, 0x62, 0x1e, 0x32, 0x65,
	0x65, 0xd0, 0x90, 0x4c, 0xbe, 0x9e, 0xb0, 0xbf, 0xb0, 0x66, 0x7b, 0x70, 0x2c, 0xf0, 0x3c, 0x7c,
	0x67, 0xd5, 0x50, 0x95, 0x9d, 0x37, 0xe6, 0x9b, 0x1c, 0xc2, 0x0a, 0xbe, 0x8b, 0x43, 0xdb, 0x22,
	0xd3, 0xe0, 0xf9, 0x3b, 0x1b, 0xfc, 0x60, 0x1c, 0x62, 0xba, 0xdc, 0x80, 0x45, 0x2d, 0x26, 0x5d,
	0xf1, 0x42, 0xda, 0x3b, 0x3f, 0x60, 0x9a, 0xd3, 0xcf, 0x81, 0x20, 0xa3, 0xbd, 0x08, 0xbd, 0x88,
	0x5f, 0x7b, 0x11, 0x55, 0xc8, 0xfc, 0xa1, 0x11, 0x40, 0xb5, 0x5b, 0x4f, 0x2d, 0xc7, 0xfc, 0xfa,
	0x38, 0xc5, 0x35, 0x2f, 0x6b, 0x87, 0x02, 0xa9, 0xc2, 0x11, 0x3b, 0x5d, 0xfc, 0x25, 0x41, 0xa9,
	0x72, 0xba, 0x2f, 0xe5, 0x75, 0x3f, 0xc5, 0xdd, 0xdc, 0x7d, 0xb8, 0x2b, 0xdf, 0x83, 0xbb, 0xf9,
	0x1c, 0x77, 0x6d, 0x70, 0x94, 0x8a, 0x46, 0xba, 0x5e, 0x30, 0xba, 0x06, 0xa5, 0xa2, 0x4c, 0xd2,
	0x13, 0xbc, 0x54, 0xde, 0x83, 0x97, 0xc5, 0x1b, 0x78, 0xf9, 0x73, 0x0e, 0x1a, 0x05, 0x5e, 0x64,
	0xcc, 0x99, 0x44, 0xf2, 0x09, 0xac, 0x08, 0xd5, 0x8f, 0xbd, 0x90, 0x5d, 0x64, 0xa2, 0x4b, 0xd9,
	0x59, 0xd6, 0xf0, 0x91, 0x41, 0xf5, 0x8d, 0xdb, 0xb0, 0x34, 0xb5, 0x15, 0x52, 0x92, 0x9c, 0x78,
	0x62, 0x25, 0xb4, 0xc1, 0x31, 0x47, 0x49, 0x14, 0x03, 0x14, 0x96, 0x19, 0xd0, 0xd0, 0x89, 0x41,
	0xc8, 0x06, 0xd4, 0xa4, 0x49, 0xe0, 0x0a, 0x87, 0x96, 0x8c, 0x31, 0x90, 0xdf, 0x5d, 0x0b, 0x77,
	0xec, 0xae, 0x4a, 0xbe, 0x87, 0x2f, 0x80, 0x8c, 0x0e, 0xf3, 0xfa, 0x76, 0x2a, 0x0c, 0x27, 0xce,
	0xde, 0xda, 0xae, 0x5e, 0xba, 0x85, 0x99, 0xe9, 0xae, 0x8e, 0x22, 0x32, 0xc8, 0xfd, 0x02, 0xea,
	0x3f, 0xa2, 0x4a, 0x5d, 0xdf, 0x4f, 0x3d, 0xee, 0x57, 0xb0, 0x3a, 0x11, 0x62, 0x89, 0x7d, 0xac,
	0xd7, 0x91, 0x46, 0x8c, 0xbf, 0xb3, 0xe7, 0x4c, 0xa4, 0xd0, 0xb5, 0x26, 0x77, 0x07, 0xc8, 0x71,
	0x28, 0x6d, 0xa8, 0xcc, 0xae, 0x23, 0x30, 0xaf, 0x86, 0x31, 0xda, 0x8b, 0xcc, 0xdf, 0xee, 0x37,
	0xf0, 0xc1, 0x94, 0xa7, 0xbd, 0xe5, 0x63, 0x58, 0x4c, 0x8f, 0x92, 0xcd, 0xd2, 0x56, 0x39, 0x7f,
	0x4d, 0x66, 0x73, 0x09, 0xd4, 0x0f, 0x2f, 0xd1, 0xbf, 0xfa, 0x3e, 0xd1, 0xcb, 0xcc, 0xdc, 0xe2,
	0x7e, 0x0d, 0xab, 0x13, 0xd8, 0x58, 0x0e, 0xd1, 0x40, 0x7a, 0xc5, 0x47, 0x64, 0x39, 0x1a, 0xc8,
	0xc3, 0x51, 0x2f, 0xdc, 0x67, 0xf0, 0x48, 0xc7, 0x71, 0x11, 0xfe, 0x8a, 0x07, 0x82, 0xd3, 0xc0,
	0xa7, 0x52, 0x65, 0xf9, 0x4f, 0xf5, 0xb9, 0x94, 0xeb, 0xb3, 0xfb, 0xd7, 0x1c, 0xb4, 0x66, 0xc5,
	0xda, 0x0c, 0xfe, 0xaf, 0x93, 0x7a, 0xbb, 0x36, 0xb7, 0x61, 0xc9, 0xbf, 0xa4, 0x8c, 0x61, 0xe4,
	0x31, 0xda, 0x47, 0xab, 0x4e, 0xc7, 0x62, 0xaf, 0xe9, 0xf4, 0x92, 0x5b, 0x9c, 0x1a, 0xe6, 0x36,
	0x38, 0x93, 0x53, 0x5c, 0x35, 0x53, 0x0c, 0xd1, 0x78, 0x7e, 0x9f, 0xc3, 0x7a, 0x17, 0x65, 0xa6,
	0xb0, 0x97, 0x38, 0x3c, 0x41, 0x5f, 0xe0, 0x88, 0xee, 0xbb, 0x1e, 0x7d, 0x77, 0x13, 0x36, 0x66,
	0xc7, 0xa7, 0x94, 0xbb, 0x4f, 0x61, 0xed, 0x07, 0xf4, 0x79, 0x50, 0x5c, 0x9b, 0xb7, 0x77, 0xf2,
	0xf7, 0x12, 0x34, 0x0a, 0x81, 0xb6, 0x8d, 0xff, 0xf5, 0x97, 0xc8, 0xec, 0x69, 0x2e, 0xdf, 0x77,
	0x9a, 0xf7, 0xf4, 0x4b, 0xc9, 0xe3, 0x7b, 0x8d, 0xf3, 0x43, 0x20, 0x93, 0x31, 0x69, 0x41, 0x7b,
	0x7f, 0x97, 0xa0, 0x79, 0x1c, 0x0e, 0xf0, 0x2c, 0x0c, 0x90, 0xeb, 0x85, 0x16, 0xfa, 0x78, 0xc4,
	0x14, 0x0a, 0x46, 0x23, 0x72, 0x0a, 0xa4, 0x28, 0x69, 0xb2, 0x69, 0xf2, 0xbc, 0x71, 0x4e, 0x5a,
	0xed, 0x1b, 0xed, 0x96, 0xc4, 0x9f, 0xe1, 0xe1, 0xac, 0xc6, 0x91, 0x2d, 0x13, 0x78, 0x8b, 0x26,
	0x5a, 0xdb, 0xb7, 0x78, 0xd8, 0x82, 0xfe, 0x28, 0x43, 0x3d, 0x5f, 0x10, 0xd9, 0x87, 0xda, 0x68,
	0x29, 0x90, 0x0f, 0xcd, 0x21, 0xf9, 0xc5, 0xd1, 0x5a, 0xcb, 0xc3, 0x36, 0xdb, 0x63, 0x58, 0xc9,
	0xbd, 0x32, 0x64, 0x3d, 0x75, 0x9d, 0xf9, 0x26, 0xb7, 0x36, 0x66, 0x1b, 0xed, 0x69, 0xfb, 0x50,
	0x1b, 0x2d, 0x55, 0x9b, 0x49, 0x7e, 0x2f, 0xdb, 0x4c, 0x8a, 0xbb, 0xf7, 0x3b, 0x70, 0x26, 0x96,
	0x25, 0x69, 0x18, 0xb7, 0xe2, 0xa2, 0x6d, 0x35, 0x8b, 0x86, 0x71, 0x2d, 0x39, 0x65, 0xdb, 0x5a,
	0x66, 0x0f, 0x8a, 0xad, 0xe5, 0xa6, 0x61, 0xf8, 0x16, 0x60, 0xac, 0x28, 0x92, 0xc9, 0x37, 0x27,
	0xcb, 0x56, 0xa3, 0x80, 0xa7, 0xe1, 0x07, 0x0b, 0x3f, 0xe9, 0x7f, 0x14, 0x7a, 0x15, 0xf3, 0x4b,
	0xaa, 0xf3, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x4c, 0x43, 0xb6, 0x57, 0x41, 0x0c, 0x00, 0x00,
}
