#!/bin/bash
set -euo pipefail
go get -u code.justin.tv/video/bingo
go get -u github.com/jstemmer/go-junit-report

# bingo build and generate coverage/test reports
export AWS_ACCESS_KEY_ID=$AWS_ACCESS_KEY_ID
export AWS_SECRET_ACCESS_KEY=$AWS_SECRET_ACCESS_KEY
bingo lint --container --root-path=/mnt/jenkins/workspace/video-lvsapi --root-import=code.justin.tv/video/lvsapi --git-sha=$GIT_COMMIT
bingo test -v --coverage=cover.out --container --root-path=/mnt/jenkins/workspace/video-lvsapi --root-import=code.justin.tv/video/lvsapi --git-sha=$GIT_COMMIT | tee test_report.txt
bingo build --container --root-path=/mnt/jenkins/workspace/video-lvsapi --root-import=code.justin.tv/video/lvsapi --git-sha=$GIT_COMMIT
cat test_report.txt | go-junit-report > test_report.xml
cat cover.out | sed 's/code.justin.tv\/video\/lvsapi/\./g' > fixed_cover.out
mv -f fixed_cover.out cover.out

# push the docker container and make app.zip
TAG=docker-registry.internal.justin.tv/video/lvsapi:$(git rev-parse HEAD)
docker build -t $TAG .
docker push $TAG
cat Dockerrun.aws.json.template | sed "s#<<TAG>>#${TAG}#" > Dockerrun.aws.json
zip -r app.zip Dockerrun.aws.json .ebextensions
