package streamkey

import (
	"io/ioutil"
	"os"
	"path"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestSaveLoadSecret(t *testing.T) {
	secret, err := GenerateSecret()
	require.NoError(t, err)

	tempDir, err := ioutil.TempDir("", "")
	require.NoError(t, err)
	defer os.RemoveAll(tempDir)

	require.NoError(t, SaveSecret(path.Join(tempDir, "secret.pem"), secret))
	loadedSecret, err := LoadSecret(path.Join(tempDir, "secret.pem"))
	require.NoError(t, err)

	assert.Equal(t, secret.bytes, loadedSecret.bytes)
}
