package codepipeline

import (
	"code.justin.tv/vodsvc/aws/awsconfig"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/codepipeline"
)

type Approval struct {
	PipelineName string `json:"pipelineName"`
	StageName    string `json:"stageName"`
	ActionName   string `json:"actionName"`
	Token        string `json:"token"`
	Expires      string `json:"expires"`
}

type ApprovalMessage struct {
	Region      string   `json:"region"`
	ConsoleLink string   `json:"consoleLink"`
	Approval    Approval `json:"approval"`
}

type ApprovalFunc func(msg ApprovalMessage) error

const (
	Approved = "Approved"
	Rejected = "Rejected"
)

func Approve(msg ApprovalMessage, f ApprovalFunc) error {
	awsconfig.Logger.Log("Running approval step:", msg)
	err := f(msg)

	var status string
	var summary string
	if err == nil {
		awsconfig.Logger.Log("Approval step succeeded.")
		status = Approved
		summary = "Success"
	} else {
		awsconfig.Logger.Log("Approval step failed: ", err)
		status = Rejected
		summary = err.Error()
	}

	cp := codepipeline.New(awsconfig.NewSession())
	input := &codepipeline.PutApprovalResultInput{
		ActionName:   aws.String(msg.Approval.ActionName),
		PipelineName: aws.String(msg.Approval.PipelineName),
		Result: &codepipeline.ApprovalResult{
			Status:  aws.String(status),
			Summary: aws.String(summary),
		},
		StageName: aws.String(msg.Approval.StageName),
		Token:     aws.String(msg.Approval.Token),
	}
	if _, err := cp.PutApprovalResult(input); err != nil {
		return err
	}
	return nil
}
