package s3

import (
	"fmt"
	"strings"
)

func BucketAndKeyFromPath(path string) (bucket, key string, err error) {
	if path[0:3] == "/s3/" {
		path = path[4:]
	}
	split := strings.SplitN(path, "/", 2)
	if len(split) != 2 {
		return "", "", fmt.Errorf("Invalid s3 file path: %s", path)
	}

	return split[0], split[1], nil
}
