package httpserver

import (
	"errors"
	"net/http"
	"runtime"
)

func Recoverer(h http.Handler) http.Handler {
	return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		defer func() {
			if r := recover(); r != nil {
				var err error
				switch x := r.(type) {
				case string:
					err = errors.New(x)
				case error:
					err = x
				default:
					err = errors.New("Unknown panic")
				}
				stack := make([]byte, 4<<10)
				length := runtime.Stack(stack, false)
				logger.Debugw("Error serving request", "stacktrace", string(stack[:length]))
				respondJSON(w, nil, InternalServerError(err))
			}
		}()
		h.ServeHTTP(w, r)
	})
}
