#!/bin/bash

set -e

S3_BUCKET="vhs.us-west-2.twitch-transcoder"

function cache() {
  bin=$1
  binpath=${BIN_CACHE}/${bin}
  localMD5=$(md5sum ${binpath} | cut -d' ' -f1)
  remoteMD5=$(aws s3api head-object --bucket ${S3_BUCKET} --key ${bin} | jq -r '.Metadata.md5')
  if [ ! -f "${binpath}" ] || [ "$localMD5" != "$remoteMD5" ]; then
    aws s3 cp s3://${S3_BUCKET}/${bin} ${binpath}
    chmod +x ${binpath}
  else
    echo "${binpath} already exists and is latest version (md5=${localMD5})"
  fi
  cp ${binpath} build/${bin}
}

mkdir -p build
cache TwitchTranscoder
cache ffprobe
