package probe

import (
	"bytes"
	"os/exec"

	"code.justin.tv/vodsvc/sts/src/transcoder"
)

const ffprobe = "/usr/local/bin/ffprobe"

func Probe(assetFile string) (VideoMetadata, *transcoder.Error) {
	cmd := exec.Command(ffprobe,
		"-i", assetFile,
		"-of", "json",
		"-show_format",
		"-show_error",
		"-show_streams",
	)

	stdout := bytes.NewBuffer(nil)
	stderr := bytes.NewBuffer(nil)

	cmd.Stdout = stdout
	cmd.Stderr = stderr
	err := cmd.Run()
	var md = VideoMetadata{}

	if err != nil {
		// If it ran but the file was bad, then ffprobe returns with exit
		// code 1, but a helpful error JSON message gets written to
		// stdout. Try to parse it, if we can.
		prettyErr, parseErr := parseFFprobeError(stdout.Bytes())
		if parseErr != nil {
			return md, transcoder.NewErrInternalFailure("ffprobe error: " + err.Error())
		}
		return md, transcoder.NewErrBadSource(prettyErr.String)
	}
	md, err = parseFFprobeOutput(stdout.Bytes())
	if err != nil {
		return md, transcoder.NewErrInternalFailure("ffprobe parse error: " + err.Error())
	}
	return md, nil
}
