package probe

import (
	"time"
)

// A VideoProbe is capable of inspecting a video asset and learning
// metadata about the asset, like its height, width, bitrate,
// duration, and codecs.
type VideoProbe interface {
	Probe(assetFilename string) (VideoMetadata, error)
}

// CodecName is a type to ensure that fixed codec strings are used
// consistently.
type CodecName string

// Available codecs are h264 and aac
const (
	H264 CodecName = "h264"
	AAC  CodecName = "aac"
)

// VideoMetadata describes the contents of a video asset.
type VideoMetadata struct {
	AudioStreams []Audio
	VideoStreams []Video
}

// Video describes the video component of a video asset.
type Video struct {
	Codec    CodecName
	Width    int
	Height   int
	BitRate  int
	Duration time.Duration
}

// Audio describes the audio component of a video asset.
type Audio struct {
	Codec    CodecName
	BitRate  int
	Duration time.Duration
}
