package transcoder

const (
	StatusSuccess = "success"
	StatusFailure = "failure"

	ErrInternalFailure   = "internal_failure"
	ErrUnsupportedFormat = "unsupported_format"
	ErrBadSource         = "invalid_source"
)

type Error struct {
	Code    string
	Message string
}

func (e *Error) Error() string {
	return e.Code + ": " + e.Message
}

func NewErrInternalFailure(msg string) *Error {
	return &Error{Code: ErrInternalFailure, Message: msg}
}

func NewErrBadSource(msg string) *Error {
	return &Error{Code: ErrBadSource, Message: msg}
}

func NewErrUnsupportedFormat(msg string) *Error {
	return &Error{Code: ErrUnsupportedFormat, Message: msg}
}

type Video struct {
	Id            string
	Renditions    []Rendition
	Thumbnails    []Thumbnail
	Duration      int32
	Status        string
	FailureCode   string
	FailureReason string
}

type Thumbnail struct {
	Path   string
	Offset float64
}

type Rendition struct {
	Bitrate    int32
	Segments   []Segment
	Label      string
	Path       string
	Manifest   string
	Height     int32
	Width      int32
	VideoCodec string
	AudioCodec string
	MaxFPS     float64
	Duration   int32
}

type Segment struct {
	Index    int32
	Name     string
	Duration float64
}
