// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehend

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opBatchDetectDominantLanguage = "BatchDetectDominantLanguage"

// BatchDetectDominantLanguageRequest generates a "aws/request.Request" representing the
// client's request for the BatchDetectDominantLanguage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDetectDominantLanguage for more information on using the BatchDetectDominantLanguage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDetectDominantLanguageRequest method.
//    req, resp := client.BatchDetectDominantLanguageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectDominantLanguage
func (c *Comprehend) BatchDetectDominantLanguageRequest(input *BatchDetectDominantLanguageInput) (req *request.Request, output *BatchDetectDominantLanguageOutput) {
	op := &request.Operation{
		Name:       opBatchDetectDominantLanguage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDetectDominantLanguageInput{}
	}

	output = &BatchDetectDominantLanguageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDetectDominantLanguage API operation for Amazon Comprehend.
//
// Determines the dominant language of the input text for a batch of documents.
// For a list of languages that Amazon Comprehend can detect, see Amazon Comprehend
// Supported Languages (http://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation BatchDetectDominantLanguage for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTextSizeLimitExceededException "TextSizeLimitExceededException"
//   The size of the input text exceeds the limit. Use a smaller document.
//
//   * ErrCodeBatchSizeLimitExceededException "BatchSizeLimitExceededException"
//   The number of documents in the request exceeds the limit of 25. Try your
//   request again with fewer documents.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectDominantLanguage
func (c *Comprehend) BatchDetectDominantLanguage(input *BatchDetectDominantLanguageInput) (*BatchDetectDominantLanguageOutput, error) {
	req, out := c.BatchDetectDominantLanguageRequest(input)
	return out, req.Send()
}

// BatchDetectDominantLanguageWithContext is the same as BatchDetectDominantLanguage with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDetectDominantLanguage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) BatchDetectDominantLanguageWithContext(ctx aws.Context, input *BatchDetectDominantLanguageInput, opts ...request.Option) (*BatchDetectDominantLanguageOutput, error) {
	req, out := c.BatchDetectDominantLanguageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDetectEntities = "BatchDetectEntities"

// BatchDetectEntitiesRequest generates a "aws/request.Request" representing the
// client's request for the BatchDetectEntities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDetectEntities for more information on using the BatchDetectEntities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDetectEntitiesRequest method.
//    req, resp := client.BatchDetectEntitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectEntities
func (c *Comprehend) BatchDetectEntitiesRequest(input *BatchDetectEntitiesInput) (req *request.Request, output *BatchDetectEntitiesOutput) {
	op := &request.Operation{
		Name:       opBatchDetectEntities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDetectEntitiesInput{}
	}

	output = &BatchDetectEntitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDetectEntities API operation for Amazon Comprehend.
//
// Inspects the text of a batch of documents and returns information about them.
// For more information about entities, see how-entities
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation BatchDetectEntities for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTextSizeLimitExceededException "TextSizeLimitExceededException"
//   The size of the input text exceeds the limit. Use a smaller document.
//
//   * ErrCodeUnsupportedLanguageException "UnsupportedLanguageException"
//   Amazon Comprehend can't process the language of the input text. For all APIs
//   except DetectDominantLanguage, Amazon Comprehend accepts only English or
//   Spanish text. For the DetectDominantLanguage API, Amazon Comprehend detects
//   100 languages. For a list of languages, see how-languages
//
//   * ErrCodeBatchSizeLimitExceededException "BatchSizeLimitExceededException"
//   The number of documents in the request exceeds the limit of 25. Try your
//   request again with fewer documents.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectEntities
func (c *Comprehend) BatchDetectEntities(input *BatchDetectEntitiesInput) (*BatchDetectEntitiesOutput, error) {
	req, out := c.BatchDetectEntitiesRequest(input)
	return out, req.Send()
}

// BatchDetectEntitiesWithContext is the same as BatchDetectEntities with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDetectEntities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) BatchDetectEntitiesWithContext(ctx aws.Context, input *BatchDetectEntitiesInput, opts ...request.Option) (*BatchDetectEntitiesOutput, error) {
	req, out := c.BatchDetectEntitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDetectKeyPhrases = "BatchDetectKeyPhrases"

// BatchDetectKeyPhrasesRequest generates a "aws/request.Request" representing the
// client's request for the BatchDetectKeyPhrases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDetectKeyPhrases for more information on using the BatchDetectKeyPhrases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDetectKeyPhrasesRequest method.
//    req, resp := client.BatchDetectKeyPhrasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectKeyPhrases
func (c *Comprehend) BatchDetectKeyPhrasesRequest(input *BatchDetectKeyPhrasesInput) (req *request.Request, output *BatchDetectKeyPhrasesOutput) {
	op := &request.Operation{
		Name:       opBatchDetectKeyPhrases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDetectKeyPhrasesInput{}
	}

	output = &BatchDetectKeyPhrasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDetectKeyPhrases API operation for Amazon Comprehend.
//
// Detects the key noun phrases found in a batch of documents.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation BatchDetectKeyPhrases for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTextSizeLimitExceededException "TextSizeLimitExceededException"
//   The size of the input text exceeds the limit. Use a smaller document.
//
//   * ErrCodeUnsupportedLanguageException "UnsupportedLanguageException"
//   Amazon Comprehend can't process the language of the input text. For all APIs
//   except DetectDominantLanguage, Amazon Comprehend accepts only English or
//   Spanish text. For the DetectDominantLanguage API, Amazon Comprehend detects
//   100 languages. For a list of languages, see how-languages
//
//   * ErrCodeBatchSizeLimitExceededException "BatchSizeLimitExceededException"
//   The number of documents in the request exceeds the limit of 25. Try your
//   request again with fewer documents.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectKeyPhrases
func (c *Comprehend) BatchDetectKeyPhrases(input *BatchDetectKeyPhrasesInput) (*BatchDetectKeyPhrasesOutput, error) {
	req, out := c.BatchDetectKeyPhrasesRequest(input)
	return out, req.Send()
}

// BatchDetectKeyPhrasesWithContext is the same as BatchDetectKeyPhrases with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDetectKeyPhrases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) BatchDetectKeyPhrasesWithContext(ctx aws.Context, input *BatchDetectKeyPhrasesInput, opts ...request.Option) (*BatchDetectKeyPhrasesOutput, error) {
	req, out := c.BatchDetectKeyPhrasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDetectSentiment = "BatchDetectSentiment"

// BatchDetectSentimentRequest generates a "aws/request.Request" representing the
// client's request for the BatchDetectSentiment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDetectSentiment for more information on using the BatchDetectSentiment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDetectSentimentRequest method.
//    req, resp := client.BatchDetectSentimentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectSentiment
func (c *Comprehend) BatchDetectSentimentRequest(input *BatchDetectSentimentInput) (req *request.Request, output *BatchDetectSentimentOutput) {
	op := &request.Operation{
		Name:       opBatchDetectSentiment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDetectSentimentInput{}
	}

	output = &BatchDetectSentimentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDetectSentiment API operation for Amazon Comprehend.
//
// Inspects a batch of documents and returns an inference of the prevailing
// sentiment, POSITIVE, NEUTRAL, MIXED, or NEGATIVE, in each one.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation BatchDetectSentiment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTextSizeLimitExceededException "TextSizeLimitExceededException"
//   The size of the input text exceeds the limit. Use a smaller document.
//
//   * ErrCodeUnsupportedLanguageException "UnsupportedLanguageException"
//   Amazon Comprehend can't process the language of the input text. For all APIs
//   except DetectDominantLanguage, Amazon Comprehend accepts only English or
//   Spanish text. For the DetectDominantLanguage API, Amazon Comprehend detects
//   100 languages. For a list of languages, see how-languages
//
//   * ErrCodeBatchSizeLimitExceededException "BatchSizeLimitExceededException"
//   The number of documents in the request exceeds the limit of 25. Try your
//   request again with fewer documents.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectSentiment
func (c *Comprehend) BatchDetectSentiment(input *BatchDetectSentimentInput) (*BatchDetectSentimentOutput, error) {
	req, out := c.BatchDetectSentimentRequest(input)
	return out, req.Send()
}

// BatchDetectSentimentWithContext is the same as BatchDetectSentiment with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDetectSentiment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) BatchDetectSentimentWithContext(ctx aws.Context, input *BatchDetectSentimentInput, opts ...request.Option) (*BatchDetectSentimentOutput, error) {
	req, out := c.BatchDetectSentimentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTopicsDetectionJob = "DescribeTopicsDetectionJob"

// DescribeTopicsDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTopicsDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTopicsDetectionJob for more information on using the DescribeTopicsDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTopicsDetectionJobRequest method.
//    req, resp := client.DescribeTopicsDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeTopicsDetectionJob
func (c *Comprehend) DescribeTopicsDetectionJobRequest(input *DescribeTopicsDetectionJobInput) (req *request.Request, output *DescribeTopicsDetectionJobOutput) {
	op := &request.Operation{
		Name:       opDescribeTopicsDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTopicsDetectionJobInput{}
	}

	output = &DescribeTopicsDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTopicsDetectionJob API operation for Amazon Comprehend.
//
// Gets the properties associated with a topic detection job. Use this operation
// to get the status of a detection job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribeTopicsDetectionJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeJobNotFoundException "JobNotFoundException"
//   The specified job was not found. Check the job ID and try again.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeTopicsDetectionJob
func (c *Comprehend) DescribeTopicsDetectionJob(input *DescribeTopicsDetectionJobInput) (*DescribeTopicsDetectionJobOutput, error) {
	req, out := c.DescribeTopicsDetectionJobRequest(input)
	return out, req.Send()
}

// DescribeTopicsDetectionJobWithContext is the same as DescribeTopicsDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTopicsDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribeTopicsDetectionJobWithContext(ctx aws.Context, input *DescribeTopicsDetectionJobInput, opts ...request.Option) (*DescribeTopicsDetectionJobOutput, error) {
	req, out := c.DescribeTopicsDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectDominantLanguage = "DetectDominantLanguage"

// DetectDominantLanguageRequest generates a "aws/request.Request" representing the
// client's request for the DetectDominantLanguage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectDominantLanguage for more information on using the DetectDominantLanguage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetectDominantLanguageRequest method.
//    req, resp := client.DetectDominantLanguageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectDominantLanguage
func (c *Comprehend) DetectDominantLanguageRequest(input *DetectDominantLanguageInput) (req *request.Request, output *DetectDominantLanguageOutput) {
	op := &request.Operation{
		Name:       opDetectDominantLanguage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectDominantLanguageInput{}
	}

	output = &DetectDominantLanguageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectDominantLanguage API operation for Amazon Comprehend.
//
// Determines the dominant language of the input text. For a list of languages
// that Amazon Comprehend can detect, see Amazon Comprehend Supported Languages
// (http://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DetectDominantLanguage for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTextSizeLimitExceededException "TextSizeLimitExceededException"
//   The size of the input text exceeds the limit. Use a smaller document.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectDominantLanguage
func (c *Comprehend) DetectDominantLanguage(input *DetectDominantLanguageInput) (*DetectDominantLanguageOutput, error) {
	req, out := c.DetectDominantLanguageRequest(input)
	return out, req.Send()
}

// DetectDominantLanguageWithContext is the same as DetectDominantLanguage with the addition of
// the ability to pass a context and additional request options.
//
// See DetectDominantLanguage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DetectDominantLanguageWithContext(ctx aws.Context, input *DetectDominantLanguageInput, opts ...request.Option) (*DetectDominantLanguageOutput, error) {
	req, out := c.DetectDominantLanguageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectEntities = "DetectEntities"

// DetectEntitiesRequest generates a "aws/request.Request" representing the
// client's request for the DetectEntities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectEntities for more information on using the DetectEntities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetectEntitiesRequest method.
//    req, resp := client.DetectEntitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectEntities
func (c *Comprehend) DetectEntitiesRequest(input *DetectEntitiesInput) (req *request.Request, output *DetectEntitiesOutput) {
	op := &request.Operation{
		Name:       opDetectEntities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectEntitiesInput{}
	}

	output = &DetectEntitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectEntities API operation for Amazon Comprehend.
//
// Inspects text for entities, and returns information about them. For more
// information, about entities, see how-entities.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DetectEntities for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTextSizeLimitExceededException "TextSizeLimitExceededException"
//   The size of the input text exceeds the limit. Use a smaller document.
//
//   * ErrCodeUnsupportedLanguageException "UnsupportedLanguageException"
//   Amazon Comprehend can't process the language of the input text. For all APIs
//   except DetectDominantLanguage, Amazon Comprehend accepts only English or
//   Spanish text. For the DetectDominantLanguage API, Amazon Comprehend detects
//   100 languages. For a list of languages, see how-languages
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectEntities
func (c *Comprehend) DetectEntities(input *DetectEntitiesInput) (*DetectEntitiesOutput, error) {
	req, out := c.DetectEntitiesRequest(input)
	return out, req.Send()
}

// DetectEntitiesWithContext is the same as DetectEntities with the addition of
// the ability to pass a context and additional request options.
//
// See DetectEntities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DetectEntitiesWithContext(ctx aws.Context, input *DetectEntitiesInput, opts ...request.Option) (*DetectEntitiesOutput, error) {
	req, out := c.DetectEntitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectKeyPhrases = "DetectKeyPhrases"

// DetectKeyPhrasesRequest generates a "aws/request.Request" representing the
// client's request for the DetectKeyPhrases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectKeyPhrases for more information on using the DetectKeyPhrases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetectKeyPhrasesRequest method.
//    req, resp := client.DetectKeyPhrasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectKeyPhrases
func (c *Comprehend) DetectKeyPhrasesRequest(input *DetectKeyPhrasesInput) (req *request.Request, output *DetectKeyPhrasesOutput) {
	op := &request.Operation{
		Name:       opDetectKeyPhrases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectKeyPhrasesInput{}
	}

	output = &DetectKeyPhrasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectKeyPhrases API operation for Amazon Comprehend.
//
// Detects the key noun phrases found in the text.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DetectKeyPhrases for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTextSizeLimitExceededException "TextSizeLimitExceededException"
//   The size of the input text exceeds the limit. Use a smaller document.
//
//   * ErrCodeUnsupportedLanguageException "UnsupportedLanguageException"
//   Amazon Comprehend can't process the language of the input text. For all APIs
//   except DetectDominantLanguage, Amazon Comprehend accepts only English or
//   Spanish text. For the DetectDominantLanguage API, Amazon Comprehend detects
//   100 languages. For a list of languages, see how-languages
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectKeyPhrases
func (c *Comprehend) DetectKeyPhrases(input *DetectKeyPhrasesInput) (*DetectKeyPhrasesOutput, error) {
	req, out := c.DetectKeyPhrasesRequest(input)
	return out, req.Send()
}

// DetectKeyPhrasesWithContext is the same as DetectKeyPhrases with the addition of
// the ability to pass a context and additional request options.
//
// See DetectKeyPhrases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DetectKeyPhrasesWithContext(ctx aws.Context, input *DetectKeyPhrasesInput, opts ...request.Option) (*DetectKeyPhrasesOutput, error) {
	req, out := c.DetectKeyPhrasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectSentiment = "DetectSentiment"

// DetectSentimentRequest generates a "aws/request.Request" representing the
// client's request for the DetectSentiment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectSentiment for more information on using the DetectSentiment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetectSentimentRequest method.
//    req, resp := client.DetectSentimentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectSentiment
func (c *Comprehend) DetectSentimentRequest(input *DetectSentimentInput) (req *request.Request, output *DetectSentimentOutput) {
	op := &request.Operation{
		Name:       opDetectSentiment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectSentimentInput{}
	}

	output = &DetectSentimentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectSentiment API operation for Amazon Comprehend.
//
// Inspects text and returns an inference of the prevailing sentiment (POSITIVE,
// NEUTRAL, MIXED, or NEGATIVE).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DetectSentiment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTextSizeLimitExceededException "TextSizeLimitExceededException"
//   The size of the input text exceeds the limit. Use a smaller document.
//
//   * ErrCodeUnsupportedLanguageException "UnsupportedLanguageException"
//   Amazon Comprehend can't process the language of the input text. For all APIs
//   except DetectDominantLanguage, Amazon Comprehend accepts only English or
//   Spanish text. For the DetectDominantLanguage API, Amazon Comprehend detects
//   100 languages. For a list of languages, see how-languages
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectSentiment
func (c *Comprehend) DetectSentiment(input *DetectSentimentInput) (*DetectSentimentOutput, error) {
	req, out := c.DetectSentimentRequest(input)
	return out, req.Send()
}

// DetectSentimentWithContext is the same as DetectSentiment with the addition of
// the ability to pass a context and additional request options.
//
// See DetectSentiment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DetectSentimentWithContext(ctx aws.Context, input *DetectSentimentInput, opts ...request.Option) (*DetectSentimentOutput, error) {
	req, out := c.DetectSentimentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTopicsDetectionJobs = "ListTopicsDetectionJobs"

// ListTopicsDetectionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListTopicsDetectionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTopicsDetectionJobs for more information on using the ListTopicsDetectionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTopicsDetectionJobsRequest method.
//    req, resp := client.ListTopicsDetectionJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTopicsDetectionJobs
func (c *Comprehend) ListTopicsDetectionJobsRequest(input *ListTopicsDetectionJobsInput) (req *request.Request, output *ListTopicsDetectionJobsOutput) {
	op := &request.Operation{
		Name:       opListTopicsDetectionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTopicsDetectionJobsInput{}
	}

	output = &ListTopicsDetectionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTopicsDetectionJobs API operation for Amazon Comprehend.
//
// Gets a list of the topic detection jobs that you have submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListTopicsDetectionJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ErrCodeInvalidFilterException "InvalidFilterException"
//   The filter specified for the ListTopicDetectionJobs operation is invalid.
//   Specify a different filter.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTopicsDetectionJobs
func (c *Comprehend) ListTopicsDetectionJobs(input *ListTopicsDetectionJobsInput) (*ListTopicsDetectionJobsOutput, error) {
	req, out := c.ListTopicsDetectionJobsRequest(input)
	return out, req.Send()
}

// ListTopicsDetectionJobsWithContext is the same as ListTopicsDetectionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListTopicsDetectionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListTopicsDetectionJobsWithContext(ctx aws.Context, input *ListTopicsDetectionJobsInput, opts ...request.Option) (*ListTopicsDetectionJobsOutput, error) {
	req, out := c.ListTopicsDetectionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTopicsDetectionJobsPages iterates over the pages of a ListTopicsDetectionJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTopicsDetectionJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTopicsDetectionJobs operation.
//    pageNum := 0
//    err := client.ListTopicsDetectionJobsPages(params,
//        func(page *ListTopicsDetectionJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Comprehend) ListTopicsDetectionJobsPages(input *ListTopicsDetectionJobsInput, fn func(*ListTopicsDetectionJobsOutput, bool) bool) error {
	return c.ListTopicsDetectionJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTopicsDetectionJobsPagesWithContext same as ListTopicsDetectionJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListTopicsDetectionJobsPagesWithContext(ctx aws.Context, input *ListTopicsDetectionJobsInput, fn func(*ListTopicsDetectionJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTopicsDetectionJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTopicsDetectionJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListTopicsDetectionJobsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opStartTopicsDetectionJob = "StartTopicsDetectionJob"

// StartTopicsDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartTopicsDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartTopicsDetectionJob for more information on using the StartTopicsDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartTopicsDetectionJobRequest method.
//    req, resp := client.StartTopicsDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartTopicsDetectionJob
func (c *Comprehend) StartTopicsDetectionJobRequest(input *StartTopicsDetectionJobInput) (req *request.Request, output *StartTopicsDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStartTopicsDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartTopicsDetectionJobInput{}
	}

	output = &StartTopicsDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartTopicsDetectionJob API operation for Amazon Comprehend.
//
// Starts an asynchronous topic detection job. Use the DescribeTopicDetectionJob
// operation to track the status of a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StartTopicsDetectionJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartTopicsDetectionJob
func (c *Comprehend) StartTopicsDetectionJob(input *StartTopicsDetectionJobInput) (*StartTopicsDetectionJobOutput, error) {
	req, out := c.StartTopicsDetectionJobRequest(input)
	return out, req.Send()
}

// StartTopicsDetectionJobWithContext is the same as StartTopicsDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartTopicsDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StartTopicsDetectionJobWithContext(ctx aws.Context, input *StartTopicsDetectionJobInput, opts ...request.Option) (*StartTopicsDetectionJobOutput, error) {
	req, out := c.StartTopicsDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type BatchDetectDominantLanguageInput struct {
	_ struct{} `type:"structure"`

	// A list containing the text of the input documents. The list can contain a
	// maximum of 25 documents. Each document should contain at least 20 characters
	// and must contain fewer than 5,000 bytes of UTF-8 encoded characters.
	//
	// TextList is a required field
	TextList []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDetectDominantLanguageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectDominantLanguageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDetectDominantLanguageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDetectDominantLanguageInput"}
	if s.TextList == nil {
		invalidParams.Add(request.NewErrParamRequired("TextList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTextList sets the TextList field's value.
func (s *BatchDetectDominantLanguageInput) SetTextList(v []*string) *BatchDetectDominantLanguageInput {
	s.TextList = v
	return s
}

// The result of calling the operation. The operation returns one object for
// each document that is successfully processed by the operation.
type BatchDetectDominantLanguageItemResult struct {
	_ struct{} `type:"structure"`

	// The zero-based index of the document in the input list.
	Index *int64 `type:"integer"`

	// One or more DominantLanguage objects describing the dominant languages in
	// the document.
	Languages []*DominantLanguage `type:"list"`
}

// String returns the string representation
func (s BatchDetectDominantLanguageItemResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectDominantLanguageItemResult) GoString() string {
	return s.String()
}

// SetIndex sets the Index field's value.
func (s *BatchDetectDominantLanguageItemResult) SetIndex(v int64) *BatchDetectDominantLanguageItemResult {
	s.Index = &v
	return s
}

// SetLanguages sets the Languages field's value.
func (s *BatchDetectDominantLanguageItemResult) SetLanguages(v []*DominantLanguage) *BatchDetectDominantLanguageItemResult {
	s.Languages = v
	return s
}

type BatchDetectDominantLanguageOutput struct {
	_ struct{} `type:"structure"`

	// A list containing one object for each document that contained an error. The
	// results are sorted in ascending order by the Index field and match the order
	// of the documents in the input list. If there are no errors in the batch,
	// the ErrorList is empty.
	//
	// ErrorList is a required field
	ErrorList []*BatchItemError `type:"list" required:"true"`

	// A list of objects containing the results of the operation. The results are
	// sorted in ascending order by the Index field and match the order of the documents
	// in the input list. If all of the documents contain an error, the ResultList
	// is empty.
	//
	// ResultList is a required field
	ResultList []*BatchDetectDominantLanguageItemResult `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDetectDominantLanguageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectDominantLanguageOutput) GoString() string {
	return s.String()
}

// SetErrorList sets the ErrorList field's value.
func (s *BatchDetectDominantLanguageOutput) SetErrorList(v []*BatchItemError) *BatchDetectDominantLanguageOutput {
	s.ErrorList = v
	return s
}

// SetResultList sets the ResultList field's value.
func (s *BatchDetectDominantLanguageOutput) SetResultList(v []*BatchDetectDominantLanguageItemResult) *BatchDetectDominantLanguageOutput {
	s.ResultList = v
	return s
}

type BatchDetectEntitiesInput struct {
	_ struct{} `type:"structure"`

	// The language of the input documents. All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `min:"1" type:"string" required:"true"`

	// A list containing the text of the input documents. The list can contain a
	// maximum of 25 documents. Each document must contain fewer than 5,000 bytes
	// of UTF-8 encoded characters.
	//
	// TextList is a required field
	TextList []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDetectEntitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectEntitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDetectEntitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDetectEntitiesInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.LanguageCode != nil && len(*s.LanguageCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageCode", 1))
	}
	if s.TextList == nil {
		invalidParams.Add(request.NewErrParamRequired("TextList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *BatchDetectEntitiesInput) SetLanguageCode(v string) *BatchDetectEntitiesInput {
	s.LanguageCode = &v
	return s
}

// SetTextList sets the TextList field's value.
func (s *BatchDetectEntitiesInput) SetTextList(v []*string) *BatchDetectEntitiesInput {
	s.TextList = v
	return s
}

// The result of calling the operation. The operation returns one object for
// each document that is successfully processed by the operation.
type BatchDetectEntitiesItemResult struct {
	_ struct{} `type:"structure"`

	// One or more Entity objects, one for each entity detected in the document.
	Entities []*Entity `type:"list"`

	// The zero-based index of the document in the input list.
	Index *int64 `type:"integer"`
}

// String returns the string representation
func (s BatchDetectEntitiesItemResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectEntitiesItemResult) GoString() string {
	return s.String()
}

// SetEntities sets the Entities field's value.
func (s *BatchDetectEntitiesItemResult) SetEntities(v []*Entity) *BatchDetectEntitiesItemResult {
	s.Entities = v
	return s
}

// SetIndex sets the Index field's value.
func (s *BatchDetectEntitiesItemResult) SetIndex(v int64) *BatchDetectEntitiesItemResult {
	s.Index = &v
	return s
}

type BatchDetectEntitiesOutput struct {
	_ struct{} `type:"structure"`

	// A list containing one object for each document that contained an error. The
	// results are sorted in ascending order by the Index field and match the order
	// of the documents in the input list. If there are no errors in the batch,
	// the ErrorList is empty.
	//
	// ErrorList is a required field
	ErrorList []*BatchItemError `type:"list" required:"true"`

	// A list of objects containing the results of the operation. The results are
	// sorted in ascending order by the Index field and match the order of the documents
	// in the input list. If all of the documents contain an error, the ResultList
	// is empty.
	//
	// ResultList is a required field
	ResultList []*BatchDetectEntitiesItemResult `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDetectEntitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectEntitiesOutput) GoString() string {
	return s.String()
}

// SetErrorList sets the ErrorList field's value.
func (s *BatchDetectEntitiesOutput) SetErrorList(v []*BatchItemError) *BatchDetectEntitiesOutput {
	s.ErrorList = v
	return s
}

// SetResultList sets the ResultList field's value.
func (s *BatchDetectEntitiesOutput) SetResultList(v []*BatchDetectEntitiesItemResult) *BatchDetectEntitiesOutput {
	s.ResultList = v
	return s
}

type BatchDetectKeyPhrasesInput struct {
	_ struct{} `type:"structure"`

	// The language of the input documents. All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `min:"1" type:"string" required:"true"`

	// A list containing the text of the input documents. The list can contain a
	// maximum of 25 documents. Each document must contain fewer that 5,000 bytes
	// of UTF-8 encoded characters.
	//
	// TextList is a required field
	TextList []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDetectKeyPhrasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectKeyPhrasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDetectKeyPhrasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDetectKeyPhrasesInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.LanguageCode != nil && len(*s.LanguageCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageCode", 1))
	}
	if s.TextList == nil {
		invalidParams.Add(request.NewErrParamRequired("TextList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *BatchDetectKeyPhrasesInput) SetLanguageCode(v string) *BatchDetectKeyPhrasesInput {
	s.LanguageCode = &v
	return s
}

// SetTextList sets the TextList field's value.
func (s *BatchDetectKeyPhrasesInput) SetTextList(v []*string) *BatchDetectKeyPhrasesInput {
	s.TextList = v
	return s
}

// The result of calling the operation. The operation returns one object for
// each document that is successfully processed by the operation.
type BatchDetectKeyPhrasesItemResult struct {
	_ struct{} `type:"structure"`

	// The zero-based index of the document in the input list.
	Index *int64 `type:"integer"`

	// One or more KeyPhrase objects, one for each key phrase detected in the document.
	KeyPhrases []*KeyPhrase `type:"list"`
}

// String returns the string representation
func (s BatchDetectKeyPhrasesItemResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectKeyPhrasesItemResult) GoString() string {
	return s.String()
}

// SetIndex sets the Index field's value.
func (s *BatchDetectKeyPhrasesItemResult) SetIndex(v int64) *BatchDetectKeyPhrasesItemResult {
	s.Index = &v
	return s
}

// SetKeyPhrases sets the KeyPhrases field's value.
func (s *BatchDetectKeyPhrasesItemResult) SetKeyPhrases(v []*KeyPhrase) *BatchDetectKeyPhrasesItemResult {
	s.KeyPhrases = v
	return s
}

type BatchDetectKeyPhrasesOutput struct {
	_ struct{} `type:"structure"`

	// A list containing one object for each document that contained an error. The
	// results are sorted in ascending order by the Index field and match the order
	// of the documents in the input list. If there are no errors in the batch,
	// the ErrorList is empty.
	//
	// ErrorList is a required field
	ErrorList []*BatchItemError `type:"list" required:"true"`

	// A list of objects containing the results of the operation. The results are
	// sorted in ascending order by the Index field and match the order of the documents
	// in the input list. If all of the documents contain an error, the ResultList
	// is empty.
	//
	// ResultList is a required field
	ResultList []*BatchDetectKeyPhrasesItemResult `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDetectKeyPhrasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectKeyPhrasesOutput) GoString() string {
	return s.String()
}

// SetErrorList sets the ErrorList field's value.
func (s *BatchDetectKeyPhrasesOutput) SetErrorList(v []*BatchItemError) *BatchDetectKeyPhrasesOutput {
	s.ErrorList = v
	return s
}

// SetResultList sets the ResultList field's value.
func (s *BatchDetectKeyPhrasesOutput) SetResultList(v []*BatchDetectKeyPhrasesItemResult) *BatchDetectKeyPhrasesOutput {
	s.ResultList = v
	return s
}

type BatchDetectSentimentInput struct {
	_ struct{} `type:"structure"`

	// The language of the input documents. All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `min:"1" type:"string" required:"true"`

	// A list containing the text of the input documents. The list can contain a
	// maximum of 25 documents. Each document must contain fewer that 5,000 bytes
	// of UTF-8 encoded characters.
	//
	// TextList is a required field
	TextList []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDetectSentimentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectSentimentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDetectSentimentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDetectSentimentInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.LanguageCode != nil && len(*s.LanguageCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageCode", 1))
	}
	if s.TextList == nil {
		invalidParams.Add(request.NewErrParamRequired("TextList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *BatchDetectSentimentInput) SetLanguageCode(v string) *BatchDetectSentimentInput {
	s.LanguageCode = &v
	return s
}

// SetTextList sets the TextList field's value.
func (s *BatchDetectSentimentInput) SetTextList(v []*string) *BatchDetectSentimentInput {
	s.TextList = v
	return s
}

// The result of calling the operation. The operation returns one object for
// each document that is successfully processed by the operation.
type BatchDetectSentimentItemResult struct {
	_ struct{} `type:"structure"`

	// The zero-based index of the document in the input list.
	Index *int64 `type:"integer"`

	// The sentiment detected in the document.
	Sentiment *string `type:"string" enum:"SentimentType"`

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// sentiment detection.
	SentimentScore *SentimentScore `type:"structure"`
}

// String returns the string representation
func (s BatchDetectSentimentItemResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectSentimentItemResult) GoString() string {
	return s.String()
}

// SetIndex sets the Index field's value.
func (s *BatchDetectSentimentItemResult) SetIndex(v int64) *BatchDetectSentimentItemResult {
	s.Index = &v
	return s
}

// SetSentiment sets the Sentiment field's value.
func (s *BatchDetectSentimentItemResult) SetSentiment(v string) *BatchDetectSentimentItemResult {
	s.Sentiment = &v
	return s
}

// SetSentimentScore sets the SentimentScore field's value.
func (s *BatchDetectSentimentItemResult) SetSentimentScore(v *SentimentScore) *BatchDetectSentimentItemResult {
	s.SentimentScore = v
	return s
}

type BatchDetectSentimentOutput struct {
	_ struct{} `type:"structure"`

	// A list containing one object for each document that contained an error. The
	// results are sorted in ascending order by the Index field and match the order
	// of the documents in the input list. If there are no errors in the batch,
	// the ErrorList is empty.
	//
	// ErrorList is a required field
	ErrorList []*BatchItemError `type:"list" required:"true"`

	// A list of objects containing the results of the operation. The results are
	// sorted in ascending order by the Index field and match the order of the documents
	// in the input list. If all of the documents contain an error, the ResultList
	// is empty.
	//
	// ResultList is a required field
	ResultList []*BatchDetectSentimentItemResult `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDetectSentimentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectSentimentOutput) GoString() string {
	return s.String()
}

// SetErrorList sets the ErrorList field's value.
func (s *BatchDetectSentimentOutput) SetErrorList(v []*BatchItemError) *BatchDetectSentimentOutput {
	s.ErrorList = v
	return s
}

// SetResultList sets the ResultList field's value.
func (s *BatchDetectSentimentOutput) SetResultList(v []*BatchDetectSentimentItemResult) *BatchDetectSentimentOutput {
	s.ResultList = v
	return s
}

// Describes an error that occurred while processing a document in a batch.
// The operation returns on BatchItemError object for each document that contained
// an error.
type BatchItemError struct {
	_ struct{} `type:"structure"`

	// The numeric error code of the error.
	ErrorCode *string `min:"1" type:"string"`

	// A text description of the error.
	ErrorMessage *string `min:"1" type:"string"`

	// The zero-based index of the document in the input list.
	Index *int64 `type:"integer"`
}

// String returns the string representation
func (s BatchItemError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchItemError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchItemError) SetErrorCode(v string) *BatchItemError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchItemError) SetErrorMessage(v string) *BatchItemError {
	s.ErrorMessage = &v
	return s
}

// SetIndex sets the Index field's value.
func (s *BatchItemError) SetIndex(v int64) *BatchItemError {
	s.Index = &v
	return s
}

type DescribeTopicsDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier assigned by the user to the detection job.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTopicsDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTopicsDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTopicsDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTopicsDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeTopicsDetectionJobInput) SetJobId(v string) *DescribeTopicsDetectionJobInput {
	s.JobId = &v
	return s
}

type DescribeTopicsDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The list of properties for the requested job.
	TopicsDetectionJobProperties *TopicsDetectionJobProperties `type:"structure"`
}

// String returns the string representation
func (s DescribeTopicsDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTopicsDetectionJobOutput) GoString() string {
	return s.String()
}

// SetTopicsDetectionJobProperties sets the TopicsDetectionJobProperties field's value.
func (s *DescribeTopicsDetectionJobOutput) SetTopicsDetectionJobProperties(v *TopicsDetectionJobProperties) *DescribeTopicsDetectionJobOutput {
	s.TopicsDetectionJobProperties = v
	return s
}

type DetectDominantLanguageInput struct {
	_ struct{} `type:"structure"`

	// A UTF-8 text string. Each string should contain at least 20 characters and
	// must contain fewer that 5,000 bytes of UTF-8 encoded characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DetectDominantLanguageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectDominantLanguageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectDominantLanguageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectDominantLanguageInput"}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetText sets the Text field's value.
func (s *DetectDominantLanguageInput) SetText(v string) *DetectDominantLanguageInput {
	s.Text = &v
	return s
}

type DetectDominantLanguageOutput struct {
	_ struct{} `type:"structure"`

	// The languages that Amazon Comprehend detected in the input text. For each
	// language, the response returns the RFC 5646 language code and the level of
	// confidence that Amazon Comprehend has in the accuracy of its inference. For
	// more information about RFC 5646, see Tags for Identifying Languages (https://tools.ietf.org/html/rfc5646)
	// on the IETF Tools web site.
	Languages []*DominantLanguage `type:"list"`
}

// String returns the string representation
func (s DetectDominantLanguageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectDominantLanguageOutput) GoString() string {
	return s.String()
}

// SetLanguages sets the Languages field's value.
func (s *DetectDominantLanguageOutput) SetLanguages(v []*DominantLanguage) *DetectDominantLanguageOutput {
	s.Languages = v
	return s
}

type DetectEntitiesInput struct {
	_ struct{} `type:"structure"`

	// The RFC 5646 language code of the input text. If the request does not specify
	// the language code, the service detects the dominant language. If you specify
	// a language code that the service does not support, it returns UnsupportedLanguageException
	// exception. For more information about RFC 5646, see Tags for Identifying
	// Languages (https://tools.ietf.org/html/rfc5646) on the IETF Tools web site.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8
	// encoded characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DetectEntitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectEntitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectEntitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectEntitiesInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *DetectEntitiesInput) SetLanguageCode(v string) *DetectEntitiesInput {
	s.LanguageCode = &v
	return s
}

// SetText sets the Text field's value.
func (s *DetectEntitiesInput) SetText(v string) *DetectEntitiesInput {
	s.Text = &v
	return s
}

type DetectEntitiesOutput struct {
	_ struct{} `type:"structure"`

	// A collection of entities identified in the input text. For each entity, the
	// response provides the entity text, entity type, where the entity text begins
	// and ends, and the level of confidence that Amazon Comprehend has in the detection.
	// For a list of entity types, see how-entities.
	Entities []*Entity `type:"list"`
}

// String returns the string representation
func (s DetectEntitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectEntitiesOutput) GoString() string {
	return s.String()
}

// SetEntities sets the Entities field's value.
func (s *DetectEntitiesOutput) SetEntities(v []*Entity) *DetectEntitiesOutput {
	s.Entities = v
	return s
}

type DetectKeyPhrasesInput struct {
	_ struct{} `type:"structure"`

	// The RFC 5646 language code for the input text. If you don't specify a language
	// code, Amazon Comprehend detects the dominant language. If you specify the
	// code for a language that Amazon Comprehend does not support, it returns and
	// UnsupportedLanguageException. For more information about RFC 5646, see Tags
	// for Identifying Languages (https://tools.ietf.org/html/rfc5646) on the IETF
	// Tools web site.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8
	// encoded characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DetectKeyPhrasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectKeyPhrasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectKeyPhrasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectKeyPhrasesInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *DetectKeyPhrasesInput) SetLanguageCode(v string) *DetectKeyPhrasesInput {
	s.LanguageCode = &v
	return s
}

// SetText sets the Text field's value.
func (s *DetectKeyPhrasesInput) SetText(v string) *DetectKeyPhrasesInput {
	s.Text = &v
	return s
}

type DetectKeyPhrasesOutput struct {
	_ struct{} `type:"structure"`

	// A collection of key phrases that Amazon Comprehend identified in the input
	// text. For each key phrase, the response provides the text of the key phrase,
	// where the key phrase begins and ends, and the level of confidence that Amazon
	// Comprehend has in the accuracy of the detection.
	KeyPhrases []*KeyPhrase `type:"list"`
}

// String returns the string representation
func (s DetectKeyPhrasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectKeyPhrasesOutput) GoString() string {
	return s.String()
}

// SetKeyPhrases sets the KeyPhrases field's value.
func (s *DetectKeyPhrasesOutput) SetKeyPhrases(v []*KeyPhrase) *DetectKeyPhrasesOutput {
	s.KeyPhrases = v
	return s
}

type DetectSentimentInput struct {
	_ struct{} `type:"structure"`

	// The RFC 5646 language code for the input text. If you don't specify a language
	// code, Amazon Comprehend detects the dominant language. If you specify the
	// code for a language that Amazon Comprehend does not support, it returns and
	// UnsupportedLanguageException. For more information about RFC 5646, see Tags
	// for Identifying Languages (https://tools.ietf.org/html/rfc5646) on the IETF
	// Tools web site.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8
	// encoded characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DetectSentimentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectSentimentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectSentimentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectSentimentInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *DetectSentimentInput) SetLanguageCode(v string) *DetectSentimentInput {
	s.LanguageCode = &v
	return s
}

// SetText sets the Text field's value.
func (s *DetectSentimentInput) SetText(v string) *DetectSentimentInput {
	s.Text = &v
	return s
}

type DetectSentimentOutput struct {
	_ struct{} `type:"structure"`

	// The inferred sentiment that Amazon Comprehend has the highest level of confidence
	// in.
	Sentiment *string `type:"string" enum:"SentimentType"`

	// An object that lists the sentiments, and their corresponding confidence levels.
	SentimentScore *SentimentScore `type:"structure"`
}

// String returns the string representation
func (s DetectSentimentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectSentimentOutput) GoString() string {
	return s.String()
}

// SetSentiment sets the Sentiment field's value.
func (s *DetectSentimentOutput) SetSentiment(v string) *DetectSentimentOutput {
	s.Sentiment = &v
	return s
}

// SetSentimentScore sets the SentimentScore field's value.
func (s *DetectSentimentOutput) SetSentimentScore(v *SentimentScore) *DetectSentimentOutput {
	s.SentimentScore = v
	return s
}

// Returns the code for the dominant language in the input text and the level
// of confidence that Amazon Comprehend has in the accuracy of the detection.
type DominantLanguage struct {
	_ struct{} `type:"structure"`

	// The RFC 5646 language code for the dominant language.
	LanguageCode *string `min:"1" type:"string"`

	// The level of confidence that Amazon Comprehend has in the accuracy of the
	// detection.
	Score *float64 `type:"float"`
}

// String returns the string representation
func (s DominantLanguage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DominantLanguage) GoString() string {
	return s.String()
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *DominantLanguage) SetLanguageCode(v string) *DominantLanguage {
	s.LanguageCode = &v
	return s
}

// SetScore sets the Score field's value.
func (s *DominantLanguage) SetScore(v float64) *DominantLanguage {
	s.Score = &v
	return s
}

// Provides information about an entity.
type Entity struct {
	_ struct{} `type:"structure"`

	// A character offset in the input text that shows where the entity begins (the
	// first character is at position 0). The offset returns the position of each
	// UTF-8 code point in the string. A code point is the abstract character from
	// a particular graphical representation. For example, a multi-byte UTF-8 character
	// maps to a single code point.
	BeginOffset *int64 `type:"integer"`

	// A character offset in the input text that shows where the entity ends. The
	// offset returns the position of each UTF-8 code point in the string. A code
	// point is the abstract character from a particular graphical representation.
	// For example, a multi-byte UTF-8 character maps to a single code point.
	EndOffset *int64 `type:"integer"`

	// The level of confidence that Amazon Comprehend has in the accuracy of the
	// detection.
	Score *float64 `type:"float"`

	// The text of the entity.
	Text *string `min:"1" type:"string"`

	// The entity's type.
	Type *string `type:"string" enum:"EntityType"`
}

// String returns the string representation
func (s Entity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Entity) GoString() string {
	return s.String()
}

// SetBeginOffset sets the BeginOffset field's value.
func (s *Entity) SetBeginOffset(v int64) *Entity {
	s.BeginOffset = &v
	return s
}

// SetEndOffset sets the EndOffset field's value.
func (s *Entity) SetEndOffset(v int64) *Entity {
	s.EndOffset = &v
	return s
}

// SetScore sets the Score field's value.
func (s *Entity) SetScore(v float64) *Entity {
	s.Score = &v
	return s
}

// SetText sets the Text field's value.
func (s *Entity) SetText(v string) *Entity {
	s.Text = &v
	return s
}

// SetType sets the Type field's value.
func (s *Entity) SetType(v string) *Entity {
	s.Type = &v
	return s
}

// The input properties for a topic detection job.
type InputDataConfig struct {
	_ struct{} `type:"structure"`

	// Specifies how the text in an input file should be processed:
	//
	//    * ONE_DOC_PER_FILE - Each file is considered a separate document. Use
	//    this option when you are processing large documents, such as newspaper
	//    articles or scientific papers.
	//
	//    * ONE_DOC_PER_LINE - Each line in a file is considered a separate document.
	//    Use this option when you are processing many short documents, such as
	//    text messages.
	InputFormat *string `type:"string" enum:"InputFormat"`

	// The Amazon S3 URI for the input data. The URI must be in same region as the
	// API endpoint that you are calling. The URI can point to a single input file
	// or it can provide the prefix for a collection of data files.
	//
	// For example, if you use the URI S3://bucketName/prefix, if the prefix is
	// a single file, Amazon Comprehend uses that file as input. If more than one
	// file begins with the prefix, Amazon Comprehend uses all of them as input.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s InputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputDataConfig"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputFormat sets the InputFormat field's value.
func (s *InputDataConfig) SetInputFormat(v string) *InputDataConfig {
	s.InputFormat = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *InputDataConfig) SetS3Uri(v string) *InputDataConfig {
	s.S3Uri = &v
	return s
}

// Describes a key noun phrase.
type KeyPhrase struct {
	_ struct{} `type:"structure"`

	// A character offset in the input text that shows where the key phrase begins
	// (the first character is at position 0). The offset returns the position of
	// each UTF-8 code point in the string. A code point is the abstract character
	// from a particular graphical representation. For example, a multi-byte UTF-8
	// character maps to a single code point.
	BeginOffset *int64 `type:"integer"`

	// A character offset in the input text where the key phrase ends. The offset
	// returns the position of each UTF-8 code point in the string. A code point
	// is the abstract character from a particular graphical representation. For
	// example, a multi-byte UTF-8 character maps to a single code point.
	EndOffset *int64 `type:"integer"`

	// The level of confidence that Amazon Comprehend has in the accuracy of the
	// detection.
	Score *float64 `type:"float"`

	// The text of a key noun phrase.
	Text *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KeyPhrase) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyPhrase) GoString() string {
	return s.String()
}

// SetBeginOffset sets the BeginOffset field's value.
func (s *KeyPhrase) SetBeginOffset(v int64) *KeyPhrase {
	s.BeginOffset = &v
	return s
}

// SetEndOffset sets the EndOffset field's value.
func (s *KeyPhrase) SetEndOffset(v int64) *KeyPhrase {
	s.EndOffset = &v
	return s
}

// SetScore sets the Score field's value.
func (s *KeyPhrase) SetScore(v float64) *KeyPhrase {
	s.Score = &v
	return s
}

// SetText sets the Text field's value.
func (s *KeyPhrase) SetText(v string) *KeyPhrase {
	s.Text = &v
	return s
}

type ListTopicsDetectionJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. Jobs can be filtered on their name, status,
	// or the date and time that they were submitted. You can set only one filter
	// at a time.
	Filter *TopicsDetectionJobFilter `type:"structure"`

	// The maximum number of results to return in each page.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListTopicsDetectionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTopicsDetectionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTopicsDetectionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTopicsDetectionJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListTopicsDetectionJobsInput) SetFilter(v *TopicsDetectionJobFilter) *ListTopicsDetectionJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTopicsDetectionJobsInput) SetMaxResults(v int64) *ListTopicsDetectionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTopicsDetectionJobsInput) SetNextToken(v string) *ListTopicsDetectionJobsInput {
	s.NextToken = &v
	return s
}

type ListTopicsDetectionJobsOutput struct {
	_ struct{} `type:"structure"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`

	// A list containing the properties of each job that is returned.
	TopicsDetectionJobPropertiesList []*TopicsDetectionJobProperties `type:"list"`
}

// String returns the string representation
func (s ListTopicsDetectionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTopicsDetectionJobsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTopicsDetectionJobsOutput) SetNextToken(v string) *ListTopicsDetectionJobsOutput {
	s.NextToken = &v
	return s
}

// SetTopicsDetectionJobPropertiesList sets the TopicsDetectionJobPropertiesList field's value.
func (s *ListTopicsDetectionJobsOutput) SetTopicsDetectionJobPropertiesList(v []*TopicsDetectionJobProperties) *ListTopicsDetectionJobsOutput {
	s.TopicsDetectionJobPropertiesList = v
	return s
}

// Provides configuration parameters for the output of topic detection jobs.
type OutputDataConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 URI where you want to write the output data. The URI must be
	// in the same region as the API endpoint that you are calling.
	//
	// The service creates an output file called output.tar.gz. It is a compressed
	// archive that contains two files, topic-terms.csv that lists the terms associated
	// with each topic, and doc-topics.csv that lists the documents associated with
	// each topic. For more information, see topic-modeling.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s OutputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputDataConfig"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Uri sets the S3Uri field's value.
func (s *OutputDataConfig) SetS3Uri(v string) *OutputDataConfig {
	s.S3Uri = &v
	return s
}

// Describes the level of confidence that Amazon Comprehend has in the accuracy
// of its detection of sentiments.
type SentimentScore struct {
	_ struct{} `type:"structure"`

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// detection of the MIXED sentiment.
	Mixed *float64 `type:"float"`

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// detection of the NEGATIVE sentiment.
	Negative *float64 `type:"float"`

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// detection of the NEUTRAL sentiment.
	Neutral *float64 `type:"float"`

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// detection of the POSITIVE sentiment.
	Positive *float64 `type:"float"`
}

// String returns the string representation
func (s SentimentScore) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SentimentScore) GoString() string {
	return s.String()
}

// SetMixed sets the Mixed field's value.
func (s *SentimentScore) SetMixed(v float64) *SentimentScore {
	s.Mixed = &v
	return s
}

// SetNegative sets the Negative field's value.
func (s *SentimentScore) SetNegative(v float64) *SentimentScore {
	s.Negative = &v
	return s
}

// SetNeutral sets the Neutral field's value.
func (s *SentimentScore) SetNeutral(v float64) *SentimentScore {
	s.Neutral = &v
	return s
}

// SetPositive sets the Positive field's value.
func (s *SentimentScore) SetPositive(v float64) *SentimentScore {
	s.Positive = &v
	return s
}

type StartTopicsDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you do not set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that grants Amazon Comprehend read access to your input data.
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `type:"string" required:"true"`

	// Specifies the format and location of the input data for the job.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The identifier of the job.
	JobName *string `min:"1" type:"string"`

	// The number of topics to detect.
	NumberOfTopics *int64 `min:"1" type:"integer"`

	// Specifies where to send the output files.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s StartTopicsDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartTopicsDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartTopicsDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartTopicsDetectionJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.NumberOfTopics != nil && *s.NumberOfTopics < 1 {
		invalidParams.Add(request.NewErrParamMinValue("NumberOfTopics", 1))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartTopicsDetectionJobInput) SetClientRequestToken(v string) *StartTopicsDetectionJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartTopicsDetectionJobInput) SetDataAccessRoleArn(v string) *StartTopicsDetectionJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartTopicsDetectionJobInput) SetInputDataConfig(v *InputDataConfig) *StartTopicsDetectionJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartTopicsDetectionJobInput) SetJobName(v string) *StartTopicsDetectionJobInput {
	s.JobName = &v
	return s
}

// SetNumberOfTopics sets the NumberOfTopics field's value.
func (s *StartTopicsDetectionJobInput) SetNumberOfTopics(v int64) *StartTopicsDetectionJobInput {
	s.NumberOfTopics = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartTopicsDetectionJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartTopicsDetectionJobInput {
	s.OutputDataConfig = v
	return s
}

type StartTopicsDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier generated for the job. To get the status of the job, use this
	// identifier with the DescribeTopicDetectionJob operation.
	JobId *string `min:"1" type:"string"`

	// The status of the job:
	//
	//    * SUBMITTED - The job has been received and is queued for processing.
	//
	//    * IN_PROGRESS - Amazon Comprehend is processing the job.
	//
	//    * COMPLETED - The job was successfully completed and the output is available.
	//
	//    * FAILED - The job did not complete. To get details, use the DescribeTopicDetectionJob
	//    operation.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation
func (s StartTopicsDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartTopicsDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartTopicsDetectionJobOutput) SetJobId(v string) *StartTopicsDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StartTopicsDetectionJobOutput) SetJobStatus(v string) *StartTopicsDetectionJobOutput {
	s.JobStatus = &v
	return s
}

// Provides information for filtering topic detection jobs. For more information,
// see .
type TopicsDetectionJobFilter struct {
	_ struct{} `type:"structure"`

	JobName *string `min:"1" type:"string"`

	// Filters the list of topic detection jobs based on job status. Returns only
	// jobs with the specified status.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Only returns jobs submitted after the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeAfter *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Only returns jobs submitted before the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeBefore *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s TopicsDetectionJobFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TopicsDetectionJobFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TopicsDetectionJobFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TopicsDetectionJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *TopicsDetectionJobFilter) SetJobName(v string) *TopicsDetectionJobFilter {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *TopicsDetectionJobFilter) SetJobStatus(v string) *TopicsDetectionJobFilter {
	s.JobStatus = &v
	return s
}

// SetSubmitTimeAfter sets the SubmitTimeAfter field's value.
func (s *TopicsDetectionJobFilter) SetSubmitTimeAfter(v time.Time) *TopicsDetectionJobFilter {
	s.SubmitTimeAfter = &v
	return s
}

// SetSubmitTimeBefore sets the SubmitTimeBefore field's value.
func (s *TopicsDetectionJobFilter) SetSubmitTimeBefore(v time.Time) *TopicsDetectionJobFilter {
	s.SubmitTimeBefore = &v
	return s
}

// Provides information about a topic detection job.
type TopicsDetectionJobProperties struct {
	_ struct{} `type:"structure"`

	// The time that the topic detection job was completed.
	EndTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The input data configuration supplied when you created the topic detection
	// job.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The identifier assigned to the topic detection job.
	JobId *string `min:"1" type:"string"`

	// The name of the topic detection job.
	JobName *string `min:"1" type:"string"`

	// The current status of the topic detection job. If the status is Failed, the
	// reason for the failure is shown in the Message field.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// A description for the status of a job.
	Message *string `type:"string"`

	// The number of topics to detect supplied when you created the topic detection
	// job. The default is 10.
	NumberOfTopics *int64 `type:"integer"`

	// The output data configuration supplied when you created the topic detection
	// job.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// The time that the topic detection job was submitted for processing.
	SubmitTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s TopicsDetectionJobProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TopicsDetectionJobProperties) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *TopicsDetectionJobProperties) SetEndTime(v time.Time) *TopicsDetectionJobProperties {
	s.EndTime = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *TopicsDetectionJobProperties) SetInputDataConfig(v *InputDataConfig) *TopicsDetectionJobProperties {
	s.InputDataConfig = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *TopicsDetectionJobProperties) SetJobId(v string) *TopicsDetectionJobProperties {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *TopicsDetectionJobProperties) SetJobName(v string) *TopicsDetectionJobProperties {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *TopicsDetectionJobProperties) SetJobStatus(v string) *TopicsDetectionJobProperties {
	s.JobStatus = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *TopicsDetectionJobProperties) SetMessage(v string) *TopicsDetectionJobProperties {
	s.Message = &v
	return s
}

// SetNumberOfTopics sets the NumberOfTopics field's value.
func (s *TopicsDetectionJobProperties) SetNumberOfTopics(v int64) *TopicsDetectionJobProperties {
	s.NumberOfTopics = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *TopicsDetectionJobProperties) SetOutputDataConfig(v *OutputDataConfig) *TopicsDetectionJobProperties {
	s.OutputDataConfig = v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *TopicsDetectionJobProperties) SetSubmitTime(v time.Time) *TopicsDetectionJobProperties {
	s.SubmitTime = &v
	return s
}

const (
	// EntityTypePerson is a EntityType enum value
	EntityTypePerson = "PERSON"

	// EntityTypeLocation is a EntityType enum value
	EntityTypeLocation = "LOCATION"

	// EntityTypeOrganization is a EntityType enum value
	EntityTypeOrganization = "ORGANIZATION"

	// EntityTypeCommercialItem is a EntityType enum value
	EntityTypeCommercialItem = "COMMERCIAL_ITEM"

	// EntityTypeEvent is a EntityType enum value
	EntityTypeEvent = "EVENT"

	// EntityTypeDate is a EntityType enum value
	EntityTypeDate = "DATE"

	// EntityTypeQuantity is a EntityType enum value
	EntityTypeQuantity = "QUANTITY"

	// EntityTypeTitle is a EntityType enum value
	EntityTypeTitle = "TITLE"

	// EntityTypeOther is a EntityType enum value
	EntityTypeOther = "OTHER"
)

const (
	// InputFormatOneDocPerFile is a InputFormat enum value
	InputFormatOneDocPerFile = "ONE_DOC_PER_FILE"

	// InputFormatOneDocPerLine is a InputFormat enum value
	InputFormatOneDocPerLine = "ONE_DOC_PER_LINE"
)

const (
	// JobStatusSubmitted is a JobStatus enum value
	JobStatusSubmitted = "SUBMITTED"

	// JobStatusInProgress is a JobStatus enum value
	JobStatusInProgress = "IN_PROGRESS"

	// JobStatusCompleted is a JobStatus enum value
	JobStatusCompleted = "COMPLETED"

	// JobStatusFailed is a JobStatus enum value
	JobStatusFailed = "FAILED"
)

const (
	// LanguageCodeEn is a LanguageCode enum value
	LanguageCodeEn = "en"

	// LanguageCodeEs is a LanguageCode enum value
	LanguageCodeEs = "es"
)

const (
	// SentimentTypePositive is a SentimentType enum value
	SentimentTypePositive = "POSITIVE"

	// SentimentTypeNegative is a SentimentType enum value
	SentimentTypeNegative = "NEGATIVE"

	// SentimentTypeNeutral is a SentimentType enum value
	SentimentTypeNeutral = "NEUTRAL"

	// SentimentTypeMixed is a SentimentType enum value
	SentimentTypeMixed = "MIXED"
)
