import React, { Component } from 'react';
import NavBar from './NavBar/NavBar';
import Videos from './Videos/Videos';
import Swagger from './Swagger/Swagger';
import Dashboard from './Dashboard/Dashboard';
import MuiThemeProvider from 'material-ui/styles/MuiThemeProvider';
import { BrowserRouter, Route } from 'react-router-dom';
import { withStyles } from 'material-ui/styles';
import theme from '../theme.jsx';

const styles = t => ({});

const container = {
  marginTop: 64,
  overflowY: "scroll",
  background: theme.palette.grey[100],
}

class App extends Component {
  render() {
    const videos = () => (<Videos/>);
    const swagger = () => (<Swagger/>);
    const dashboard = () => (<Dashboard/>);
    return (
      <BrowserRouter>
        <MuiThemeProvider theme={theme}>
          <div id="container" style={container}>
            <NavBar />
            <Route exact path="/" component={videos} />
            <Route path="/api" component={swagger} />
            <Route path="/dashboard" component={dashboard} />
          </div>
        </MuiThemeProvider>
      </BrowserRouter>
    );
  }
}

export default withStyles(styles)(App);
