import React from 'react';
import GraphCard from './GraphCard';
import Typography from 'material-ui/Typography';
import Divider from 'material-ui/Divider';
import TimeWindow from './TimeWindow';
import { withStyles } from 'material-ui/styles';
import { getClient } from '../../lib/vhsclient';

const styles = {
  container: {
    display: "flex",
    padding: "50px 0",
    maxWidth: "91%",
    margin: "auto",
    flexDirection: "column",
  },
  graphs: {
    display: "flex",
    flexWrap: "wrap",
    justifyContent: "center",
  },
  title: {
    flexGrow: 1,
  },
  header: {
    padding: "0 15px",
    display: "flex",
    alignItems: "center",
  }
}

class Dashboard extends React.Component {
  constructor(props) {
    super(props);
    this.client = getClient();
    this.state = {
      metricData: {}
    };
  }

  refresh = (dur) => {
    var path = "/stats?duration="+dur;
    getClient()
      .get(path)
      .then(r => {
        this.setState({ metricData: r.data });
      });
  }

  latencyData = () => {
    if (this.state.metricData.latency) {
      return {
        x: "time",
        columns: [
          ["time"].concat(this.state.metricData.latency.timestamps.map(v => new Date(v))),
          ["data1"].concat(this.state.metricData.latency.values)
        ],
      };
    } else {
      return { x: 'time', columns: [["time"]] };
    }
  }

  componentWillMount() {
    this.refresh(60);
  }

  render() {
    const classes = this.props.classes;
    if (this.state.metricData.latency) {
      var apiLatency = 
        <GraphCard 
          title="Latency"
          x={this.state.metricData.latency.timestamps}
          y={[this.state.metricData.latency.values]}
          unit="ms"
        />
    }

    if (this.state.metricData.count) {
      var apiCount = 
        <GraphCard 
          title="Volume"
          x={this.state.metricData.count.timestamps}
          y={[this.state.metricData.count.values]}
          unit="requests"
        />
    }

    if (this.state.metricData["5xx"]) {
      var apiErrors = 
        <GraphCard 
          title="Errors"
          x={this.state.metricData["5xx"].timestamps}
          y={[this.state.metricData["5xx"].values]}
          unit="errors"
        />
    }

    return (
      <div className={classes.container}>
        <div className={classes.header}>
          <div className={classes.title}> 
            <Typography variant="display1">
              API
            </Typography>
          </div>
          <TimeWindow duration={60} active={true} onClick={this.refresh} />
          <TimeWindow duration={3*60} active={true} onClick={this.refresh} />
          <TimeWindow duration={24*60} active={true} onClick={this.refresh} />
          <TimeWindow duration={3*24*60} active={true} onClick={this.refresh} />
          <TimeWindow duration={7*24*60} active={true} onClick={this.refresh} />
        </div>
        <Divider />
        <div className={classes.graphs}>
          {apiLatency}
          {apiCount}
          {apiErrors}
        </div>
      </div>
    );
  }
}

export default withStyles(styles)(Dashboard);
