import React from 'react';
import Card, { CardContent, CardHeader } from 'material-ui/Card';
import { withStyles } from 'material-ui/styles';
import C3Chart from 'react-c3js';
import d3 from 'd3';
import 'c3/c3.css';
import './custom.css';

const styles = {
  card: {
    margin: 15,
    overflow: "hidden",
    position: "relative",
  },
  content: {
    position: "relative",
  },
  header: {
    textAlign: "center",
    paddingBottom: 0,
  },
  title: {
    color: "#000",
    fontSize: 16,
  }
};

var customTimeFormat = d3.time.format.multi([
  [".%L", function(d) { return d.getMilliseconds(); }],
  [":%S", function(d) { return d.getSeconds(); }],
  ["%I:%M", function(d) { return d.getMinutes(); }],
  ["%I %p", function(d) { return d.getHours(); }],
  ["%a %d", function(d) { return d.getDay() && d.getDate() !== 1; }],
  ["%b %d", function(d) { return d.getDate() !== 1; }],
  ["%B", function(d) { return d.getMonth(); }],
  ["%Y", function() { return true; }]
]);

var padding = {
  left: 25,
  bottom: 0,
}

var legend = {
  show: false,
}

class GraphCard extends React.Component {
  constructor(props) {
    super(props);

    this.width = "350"
    this.height = "200"

    this.axis = { 
      x: { 
        type: 'timeseries', 
        tick: { 
          format: customTimeFormat,
          culling: true,
          fit: true,
          count: 10,
        }
      },
      y: {
        min: 0,
        padding: {
          bottom: 0,
        },
        label: {
          text: this.props.unit,
        }
      }
    }
    
    var tooltipFunc = (d, defaultTitleFormat, defaultValueFormat, color) => {
      return '<div id="tooltip" class="tooltip">' + 
        d3.time.format("%Y-%m-%d %H:%M:%S (Local)")(d[0].x) + ": " + 
        d3.format(".0f")(d[0].value) + ' ' + this.props.unit + '</div>';
    }

    tooltipFunc.bind(this)

    this.tooltip = {
      show: true,
      position: function (data, width, height, element) {
        return { top: this.height + 32, left: (this.width-width)/2 };
      },
      contents: tooltipFunc,
    }
  }

  metricData = () => {
    var columns = this.props.y.map((col,i) => ["data"+i].concat(col));
    var time = ["time"].concat(this.props.x.map(v => new Date(v)));
    return {
      x: "time",
      columns: [time].concat(columns),
    };
  }

  render() {
    const classes = this.props.classes;
    return (
      <Card className={classes.card}>
        <CardHeader title={this.props.title} className={classes.header} classes={{ title: classes.title }}>
        </CardHeader>
        <CardContent className={classes.content}>
          <C3Chart
            data={this.metricData()}
            axis={this.axis}
            size={{width: this.width, height: this.height}}
            tooltip={this.tooltip}
            legend={legend}
            padding={padding}
          />
        </CardContent>
      </Card>
    );
  }
}

export default withStyles(styles)(GraphCard);
