import React from 'react';
import Typography from 'material-ui/Typography';
import pretty from 'pretty-time';

const style = {
  margin: "0 10px",
}

class TimeWindow extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      active: false,
    }
  }

  durationText = () => {
    var d = this.props.duration
    if (d < 1440) {
      return pretty(d*60*1000000000);
    } else {
      return pretty(d*60*1000000000);
    }
  }

  onClick = () => {
    this.props.onClick(this.props.duration);
  }

  color = () => {
    if (this.state.active) {
      return "primary"
    } else {
      return "default"
    }
  }

  render() {
    return (
      <a href={"#"+this.durationText()} onClick={this.onClick} style={style} >
        <Typography color={this.color()} variant="button">
          {this.durationText()}
        </Typography>
      </a>
    );
  }
}

export default TimeWindow;
