import React from 'react';
import MenuIcon from 'material-ui-icons/Menu';
import VideoLibrary from 'material-ui-icons/VideoLibrary';
import Code from 'material-ui-icons/Code';
import Dashboard from 'material-ui-icons/Dashboard';
import Drawer from 'material-ui/Drawer';
import List, { ListItem, ListItemIcon, ListItemText }from 'material-ui/List';
import IconButton from 'material-ui/IconButton';
import { Link } from 'react-router-dom';
import { withStyles } from 'material-ui/styles';
import './Menu.css';

const styles = {
  menu: {
    marginRight: "auto",
  },
};

class Menu extends React.Component {
  state = {
    open: false
  }

  handleOpen = () => {
    this.setState({open: true });
  }

  handleClose = () => {
    this.setState({open: false });
  }

  render() {
    const classes = this.props.classes;
    const menu = 
      <List className={classes.list}>
        <Link to="/">
          <ListItem button onClick={this.handleClose}>
            <ListItemIcon>
              <VideoLibrary />
            </ListItemIcon>
            <ListItemText primary="Videos" />
          </ListItem>
        </Link>
        <Link to="/api">
          <ListItem button onClick={this.handleClose}>
            <ListItemIcon>
              <Code />
            </ListItemIcon>
            <ListItemText primary="API Specification" />
          </ListItem>
        </Link>
        <Link to="/dashboard">
          <ListItem button onClick={this.handleClose}>
            <ListItemIcon>
              <Dashboard />
            </ListItemIcon>
            <ListItemText primary="Dashboard" />
          </ListItem>
        </Link>
      </List>

    return (
      <div className={classes.menu}>
        <IconButton onClick={this.handleOpen} color="inherit">
          <MenuIcon />
        </IconButton>
        <Drawer open={this.state.open} onClose={this.handleClose}>
          {menu}
        </Drawer>
      </div>
    );
  }
}

export default withStyles(styles)(Menu);

