import React from 'react';
import AppBar from 'material-ui/AppBar';
import Menu from './Menu';
import SettingsButton from './Settings';
import UploadButton from './UploadButton';
import Toolbar from 'material-ui/Toolbar';
import { withStyles } from 'material-ui/styles';

const styles = (theme) => ({
  navBar: {
    width: '100%',
  },
});

class NavBar extends React.Component {
  render() {
    const classes = this.props.classes;
    return (
      <AppBar className={classes.navBar} position="fixed">
        <Toolbar className={classes.toolbar} >
          <Menu />
          <UploadButton />
          <SettingsButton />
        </Toolbar>
      </AppBar>
    );
  }
}

export default withStyles(styles)(NavBar);

