import React from 'react';
import Button from 'material-ui/Button';
import IconButton from 'material-ui/IconButton';
import Settings from 'material-ui-icons/Settings';
import TextField from 'material-ui/TextField';
import Dialog, {
  DialogActions,
  DialogContent,
  DialogTitle,
  withMobileDialog,
} from 'material-ui/Dialog';
import * as settings from '../../lib/settings';

class SettingsButton extends React.Component {
  state = {
    open: false,
    vhsEndpoint: settings.getVHSEndpoint(),
    cfEndpoint: settings.getCloudFrontEndpoint(),
  };

  handleClickOpen = () => {
    this.setState({ open: true });
  };

  handleClose = () => {
    this.setState({ open: false });
    var refreshEvent = new Event("refresh");
    window.dispatchEvent(refreshEvent);
  };

  handleChange = (name, fn) => event => {
    this.setState({
      [name]: event.target.value,
    });
    fn(event.target.value);
  };
  render() {
    return (
      <div>
        <IconButton
          onClick={this.handleClickOpen}
          color="inherit" >
          <Settings />
        </IconButton>
        <Dialog
          open={this.state.open}
          onClose={this.handleClose}
          aria-labelledby="form-dialog-title"
          maxWidth="md"
          fullWidth
        >
          <DialogTitle id="form-dialog-title">Settings</DialogTitle>
          <DialogContent>
            <TextField
              autoFocus
              label="VHS Endpoint"
              value={this.state.vhsEndpoint}
              inputProps={{value:this.state.vhsEndpoint}}
              onChange={this.handleChange('vhsEndpoint', settings.setVHSEndpoint)}
              type="uri"
              margin="normal"
              fullWidth
            />
            <TextField
              autoFocus
              label="CloudFront Endpoint"
              value={this.state.cfEndpoint}
              onChange={this.handleChange('cfEndpoint', settings.setCloudFrontEndpoint)}
              type="uri"
              margin="normal"
              fullWidth
            />
          </DialogContent>
          <DialogActions>
            <Button onClick={this.handleClose} color="primary">
              Close
            </Button>
          </DialogActions>
        </Dialog>
      </div>
    );
  }
}

export default withMobileDialog()(SettingsButton);
