import React from 'react';
import IconButton from 'material-ui/IconButton';
import FileUpload from 'material-ui-icons/FileUpload';

const inputStyle = {
  width: 0,
  position: "absolute",
  visibility:"hidden"
}

class UploadButton extends React.Component {
  handleChange = (e) => {
    var file = e.target.files[0];
    e.target.value = "";
    var uploadEvent = new CustomEvent("upload", { detail: file });
    window.dispatchEvent(uploadEvent);
  }

  render() {
    const fileInput = <input 
      ref={(e) => { this.input = e }}
      id="uploadInput" 
      type="file" 
      onChange={this.handleChange}
      style={inputStyle} />;
    return (
      <div>
        {fileInput}
        <IconButton 
          onClick={(e) => { this.input.click() }}
          color="inherit" >
          <FileUpload />
        </IconButton>
      </div>
    );
  }
}

export default UploadButton;
