import React from 'react';
import Modal, { Backdrop } from 'material-ui/Modal';
import { withStyles } from 'material-ui/styles';
import { getPlayer } from '../../lib/player';
import './Player.css';

const styles = {
  container: {
    display: "flex",
    alignItems: "center",
    justifyContent: "center",
    width: "100%",
  },
  backdrop: {
    backgroundColor: "rgba(0,0,0,0.9)",
  },
}

class Player extends React.Component {

  state = {
    open: false,
  }

  handleClose = () => {
    this.setState({ open: false });
    this.player.pause();
    this.player.src(null);
  };

  componentDidMount() {
    window.addEventListener("play", (e) => { this.play(e.detail) });
  }

  componentWillUnmount() {
    if (this.player) {
      this.player.dispose();
    }
  }

  play(src) {
    if (this.player == null) {
      this.player = getPlayer();
    }
    this.setState({ open: true });
    this.player.src(src);
    this.player.play();
  }

  render() {
    const classes = this.props.classes;

    var backdrop = () => { 
      return <Backdrop 
        open={this.state.open} 
        style={styles.backdrop} 
        onClick={this.handleClose} /> 
    };
    return (
      <Modal
        keepMounted={true}
        BackdropComponent={backdrop}
        open={this.state.open}
        onClose={this.handleClose}
        classes={{ root: classes.container }}
      >
        <div>
          <video 
            id="twitch-videojs"
            className="video-js vjs-default-skin"
            controls 
            width="600px"
          />
        </div>
      </Modal>
    );
  }
}

export default withStyles(styles)(Player);
